/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer;

import com.ardor3d.image.ImageDataFormat;
import com.ardor3d.image.PixelDataType;
import com.ardor3d.image.Texture;
import com.ardor3d.image.Texture1D;
import com.ardor3d.image.Texture2D;
import com.ardor3d.image.Texture3D;
import com.ardor3d.image.TextureCubeMap;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyRectangle2;
import com.ardor3d.math.type.ReadOnlyTransform;
import com.ardor3d.renderer.DrawBufferTarget;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.renderer.RenderLogic;
import com.ardor3d.renderer.queue.RenderQueue;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.scenegraph.AbstractBufferData;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.Renderable;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.hint.NormalsMode;
import com.ardor3d.util.Ardor3dException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Collection;
import java.util.List;

public interface Renderer {
    public static final int BUFFER_NONE = 0;
    public static final int BUFFER_COLOR = 1;
    public static final int BUFFER_DEPTH = 2;
    public static final int BUFFER_ACCUMULATION = 4;
    public static final int BUFFER_STENCIL = 8;
    public static final int BUFFER_COLOR_AND_DEPTH = 3;

    public void setBackgroundColor(ReadOnlyColorRGBA var1);

    public ReadOnlyColorRGBA getBackgroundColor();

    public void clearBuffers(int var1);

    public void clearBuffers(int var1, boolean var2);

    public void flushFrame(boolean var1);

    public void setOrtho();

    public void unsetOrtho();

    public boolean isInOrthoMode();

    public void renderBuckets();

    public void renderBuckets(boolean var1, boolean var2);

    public void clearQueue();

    public void grabScreenContents(ByteBuffer var1, ImageDataFormat var2, int var3, int var4, int var5, int var6);

    public void grabScreenContents(ByteBuffer var1, ImageDataFormat var2, PixelDataType var3, int var4, int var5, int var6, int var7);

    public int getExpectedBufferSizeToGrabScreenContents(ImageDataFormat var1, PixelDataType var2, int var3, int var4);

    public void draw(Spatial var1);

    public void flushGraphics();

    public void finishGraphics();

    public RenderQueue getQueue();

    public boolean isProcessingQueue();

    public boolean checkAndAdd(Spatial var1);

    public void deleteVBOs(Collection<Integer> var1);

    public void deleteVBOs(AbstractBufferData<?> var1);

    public void unbindVBO();

    public void updateTexture1DSubImage(Texture1D var1, int var2, int var3, ByteBuffer var4, int var5);

    public void updateTexture2DSubImage(Texture2D var1, int var2, int var3, int var4, int var5, ByteBuffer var6, int var7, int var8, int var9);

    public void updateTexture3DSubImage(Texture3D var1, int var2, int var3, int var4, int var5, int var6, int var7, ByteBuffer var8, int var9, int var10, int var11, int var12, int var13);

    public void updateTextureCubeMapSubImage(TextureCubeMap var1, TextureCubeMap.Face var2, int var3, int var4, int var5, int var6, ByteBuffer var7, int var8, int var9, int var10);

    public void checkCardError() throws Ardor3dException;

    public void draw(Renderable var1);

    public boolean doTransforms(ReadOnlyTransform var1);

    public void undoTransforms(ReadOnlyTransform var1);

    public void setupVertexData(FloatBufferData var1);

    public void setupNormalData(FloatBufferData var1);

    public void setupColorData(FloatBufferData var1);

    public void setupFogData(FloatBufferData var1);

    public void setupTextureData(List<FloatBufferData> var1);

    public void drawElements(IndexBufferData<?> var1, int[] var2, IndexMode[] var3, int var4);

    public void drawArrays(FloatBufferData var1, int[] var2, IndexMode[] var3, int var4);

    public void drawElementsVBO(IndexBufferData<?> var1, int[] var2, IndexMode[] var3, int var4);

    public void applyNormalsMode(NormalsMode var1, ReadOnlyTransform var2);

    public void applyDefaultColor(ReadOnlyColorRGBA var1);

    public void setupVertexDataVBO(FloatBufferData var1);

    public void setupNormalDataVBO(FloatBufferData var1);

    public void setupColorDataVBO(FloatBufferData var1);

    public void setupFogDataVBO(FloatBufferData var1);

    public void setupTextureDataVBO(List<FloatBufferData> var1);

    public void setupInterleavedDataVBO(FloatBufferData var1, FloatBufferData var2, FloatBufferData var3, FloatBufferData var4, List<FloatBufferData> var5);

    public void renderDisplayList(int var1);

    public void setProjectionMatrix(FloatBuffer var1);

    public FloatBuffer getProjectionMatrix(FloatBuffer var1);

    public void setModelViewMatrix(FloatBuffer var1);

    public FloatBuffer getModelViewMatrix(FloatBuffer var1);

    public void setViewport(int var1, int var2, int var3, int var4);

    public void setDepthRange(double var1, double var3);

    public void setDrawBuffer(DrawBufferTarget var1);

    public void setupLineParameters(float var1, int var2, short var3, boolean var4);

    public void setupPointParameters(float var1, boolean var2, boolean var3, boolean var4, FloatBuffer var5, float var6, float var7);

    public void applyState(RenderState.StateType var1, RenderState var2);

    public int startDisplayList();

    public void endDisplayList();

    public void loadTexture(Texture var1, int var2);

    public void deleteTexture(Texture var1);

    public void deleteTextureIds(Collection<Integer> var1);

    public void deleteDisplayLists(Collection<Integer> var1);

    public void pushClip(ReadOnlyRectangle2 var1);

    public void pushEmptyClip();

    public void popClip();

    public void clearClips();

    public void setClipTestEnabled(boolean var1);

    public boolean isClipTestEnabled();

    public RenderState getProperRenderState(RenderState.StateType var1, RenderState var2);

    public void setRenderLogic(RenderLogic var1);
}

