/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer;

import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.Renderer;

public class StereoCamera
extends Camera {
    private boolean _sideBySideMode = false;
    private final Camera _leftCamera;
    private final Camera _rightCamera;
    private double _focalDistance = 100.0;
    private double _eyeSeparation = this._focalDistance / 30.0;
    private double _aperture = 0.7853981633974483;

    public StereoCamera() {
        this(100, 100);
    }

    public StereoCamera(int width, int height) {
        super(width, height);
        this._leftCamera = new Camera(width, height);
        this._rightCamera = new Camera(width, height);
    }

    public StereoCamera(Camera camera) {
        super(camera);
        this._leftCamera = new Camera(camera);
        this._rightCamera = new Camera(camera);
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        this._leftCamera.resize(width, height);
        this._rightCamera.resize(width, height);
    }

    public boolean isSideBySideMode() {
        return this._sideBySideMode;
    }

    public void setSideBySideMode(boolean sideBySideMode) {
        this._sideBySideMode = sideBySideMode;
        this.setupLeftRightCameras();
    }

    public void setupLeftRightCameras() {
        double halfView;
        if (this._sideBySideMode) {
            this._leftCamera.setViewPort(0.0, 0.5, 0.0, 1.0);
            this._rightCamera.setViewPort(0.5, 1.0, 0.0, 1.0);
        } else {
            this._leftCamera.setViewPort(0.0, 1.0, 0.0, 1.0);
            this._rightCamera.setViewPort(0.0, 1.0, 0.0, 1.0);
        }
        double aspectRatio = (double)this.getWidth() / (double)this.getHeight() / (this._sideBySideMode ? 2.0 : 1.0);
        double top = halfView = this.getFrustumNear() * MathUtils.tan((double)(this._aperture / 2.0));
        double bottom = -halfView;
        double horizontalShift = 0.5 * this._eyeSeparation * this.getFrustumNear() / this._focalDistance;
        double left = -aspectRatio * halfView + horizontalShift;
        double right = aspectRatio * halfView + horizontalShift;
        this._leftCamera.setFrustum(this.getFrustumNear(), this.getFrustumFar(), left, right, top, bottom);
        left = -aspectRatio * halfView - horizontalShift;
        right = aspectRatio * halfView - horizontalShift;
        this._rightCamera.setFrustum(this.getFrustumNear(), this.getFrustumFar(), left, right, top, bottom);
    }

    public void updateLeftRightCameraFrames() {
        Vector3 rightDir = Vector3.fetchTempInstance();
        Vector3 work = Vector3.fetchTempInstance();
        rightDir.set(this.getDirection()).crossLocal(this.getUp()).multiplyLocal(this._eyeSeparation / 2.0);
        this._leftCamera.setFrame((ReadOnlyVector3)this.getLocation().subtract((ReadOnlyVector3)rightDir, work), this.getLeft(), this.getUp(), this.getDirection());
        this._rightCamera.setFrame((ReadOnlyVector3)this.getLocation().add((ReadOnlyVector3)rightDir, work), this.getLeft(), this.getUp(), this.getDirection());
        Vector3.releaseTempInstance((Vector3)work);
        Vector3.releaseTempInstance((Vector3)rightDir);
    }

    public void switchToLeftCamera(Renderer r) {
        this._leftCamera.update();
        this._leftCamera.apply(r);
    }

    public void switchToRightCamera(Renderer r) {
        this._rightCamera.update();
        this._rightCamera.apply(r);
    }

    public Camera getLeftCamera() {
        return this._leftCamera;
    }

    public Camera getRightCamera() {
        return this._rightCamera;
    }

    public double getFocalDistance() {
        return this._focalDistance;
    }

    public void setFocalDistance(double focalDistance) {
        this._focalDistance = focalDistance;
    }

    public double getEyeSeparation() {
        return this._eyeSeparation;
    }

    public void setEyeSeparation(double eyeSeparation) {
        this._eyeSeparation = eyeSeparation;
    }

    public double getAperture() {
        return this._aperture;
    }

    public void setAperture(double radians) {
        this._aperture = radians;
    }
}

