/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer;

import com.ardor3d.framework.DisplaySettings;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.TextureRenderer;
import com.ardor3d.renderer.TextureRendererProvider;

public enum TextureRendererFactory {
    INSTANCE;

    private TextureRendererProvider _provider = null;

    public void setProvider(TextureRendererProvider provider) {
        this._provider = provider;
    }

    public TextureRenderer createTextureRenderer(int width, int height, Renderer renderer, ContextCapabilities caps) {
        if (this._provider == null) {
            throw new IllegalStateException("No provider has been set on TextureRendererFactory.");
        }
        return this._provider.createTextureRenderer(width, height, renderer, caps);
    }

    public TextureRenderer createTextureRenderer(int width, int height, int depthBits, int samples, Renderer renderer, ContextCapabilities caps) {
        if (this._provider == null) {
            throw new IllegalStateException("No provider has been set on TextureRendererFactory.");
        }
        return this._provider.createTextureRenderer(width, height, depthBits, samples, renderer, caps);
    }

    public TextureRenderer createTextureRenderer(DisplaySettings settings, boolean forcePbuffer, Renderer renderer, ContextCapabilities caps) {
        if (this._provider == null) {
            throw new IllegalStateException("No provider has been set on TextureRendererFactory.");
        }
        return this._provider.createTextureRenderer(settings, forcePbuffer, renderer, caps);
    }
}

