/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.effect;

import com.ardor3d.framework.DisplaySettings;
import com.ardor3d.image.TextureStoreFormat;
import com.ardor3d.math.Vector3;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.effect.RenderEffect;
import com.ardor3d.renderer.effect.RenderTarget;
import com.ardor3d.renderer.effect.RenderTarget_Framebuffer;
import com.ardor3d.renderer.effect.RenderTarget_Texture2D;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.ZBufferState;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.hint.CullHint;
import com.ardor3d.scenegraph.hint.LightCombineMode;
import com.ardor3d.util.geom.BufferUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EffectManager {
    protected final DisplaySettings _canvasSettings;
    protected final List<RenderEffect> _effects = new ArrayList<RenderEffect>();
    protected final Map<String, RenderTarget> _renderTargetMap = new HashMap<String, RenderTarget>();
    protected Renderer _currentRenderer = null;
    protected RenderTarget _currentRenderTarget = null;
    protected Camera _fsqCamera;
    protected Camera _sceneCamera;
    protected Mesh _fsq;
    protected RenderTarget _inOutTargetA;
    protected RenderTarget _inOutTargetB;
    protected boolean _swapTargets = false;
    protected final TextureStoreFormat _outputFormat;

    public EffectManager(DisplaySettings settings, TextureStoreFormat outputformat) {
        this._canvasSettings = settings;
        this._fsqCamera = new Camera(settings.getWidth(), settings.getHeight());
        this._fsqCamera.setFrustum(-1.0, 1.0, -1.0, 1.0, 1.0, -1.0);
        this._fsqCamera.setProjectionMode(Camera.ProjectionMode.Parallel);
        this._fsqCamera.setAxes(Vector3.NEG_UNIT_X, Vector3.UNIT_Y, Vector3.NEG_UNIT_Z);
        this._outputFormat = outputformat;
        this.setupDefaultTargets(outputformat);
    }

    public void setupEffects() {
        for (RenderEffect effect : this._effects) {
            effect.prepare(this);
        }
    }

    protected void setupDefaultTargets(TextureStoreFormat outputformat) {
        this._renderTargetMap.put("*Framebuffer", new RenderTarget_Framebuffer());
        this._inOutTargetA = new RenderTarget_Texture2D(this._canvasSettings.getWidth(), this._canvasSettings.getHeight(), outputformat);
        this._inOutTargetB = new RenderTarget_Texture2D(this._canvasSettings.getWidth(), this._canvasSettings.getHeight(), outputformat);
    }

    public void renderEffects(Renderer renderer) {
        this._currentRenderer = renderer;
        for (RenderEffect effect : this._effects) {
            if (!effect.isEnabled()) continue;
            effect.render(this);
            this._swapTargets = !this._swapTargets;
        }
    }

    public DisplaySettings getCanvasSettings() {
        return this._canvasSettings;
    }

    public List<RenderEffect> getEffects() {
        return this._effects;
    }

    public Map<String, RenderTarget> getRenderTargetMap() {
        return this._renderTargetMap;
    }

    public Renderer getCurrentRenderer() {
        return this._currentRenderer;
    }

    public RenderTarget getCurrentRenderTarget() {
        return this._currentRenderTarget;
    }

    public void setCurrentRenderTarget(RenderTarget target) {
        this._currentRenderTarget = target;
    }

    public void addEffect(RenderEffect effect) {
        this._effects.add(effect);
    }

    public RenderTarget getRenderTarget(String name) {
        if ("*Previous".equals(name)) {
            return this._swapTargets ? this._inOutTargetB : this._inOutTargetA;
        }
        if ("*Next".equals(name)) {
            return this._swapTargets ? this._inOutTargetA : this._inOutTargetB;
        }
        return this._renderTargetMap.get(name);
    }

    public boolean setCurrentRenderTarget(String name) {
        RenderTarget target = this.getRenderTarget(name);
        if (target != null) {
            this._currentRenderTarget = target;
            return true;
        }
        return false;
    }

    public void renderFullScreenQuad(EnumMap<RenderState.StateType, RenderState> enforcedStates) {
        this._currentRenderTarget.render(this, this._fsqCamera, this.getFullScreenQuad(), enforcedStates);
    }

    protected Mesh getFullScreenQuad() {
        if (this._fsq != null) {
            return this._fsq;
        }
        this._fsq = new Mesh("fsq");
        this._fsq.getMeshData().setVertexBuffer(BufferUtils.createFloatBuffer(-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f));
        this._fsq.getMeshData().setTextureBuffer(BufferUtils.createFloatBuffer(0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f), 0);
        this._fsq.getMeshData().setIndices(BufferUtils.createIndexBufferData(new int[]{0, 1, 3, 1, 2, 3}, 3));
        this._fsq.getSceneHints().setCullHint(CullHint.Never);
        this._fsq.getSceneHints().setLightCombineMode(LightCombineMode.Off);
        ZBufferState zState = new ZBufferState();
        zState.setEnabled(false);
        this._fsq.setRenderState(zState);
        this._fsq.updateGeometricState(0.0);
        return this._fsq;
    }

    public TextureStoreFormat getOutputFormat() {
        return this._outputFormat;
    }

    public Camera getSceneCamera() {
        return this._sceneCamera;
    }

    public void setSceneCamera(Camera sceneCamera) {
        this._sceneCamera = sceneCamera;
    }
}

