/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.effect;

import com.ardor3d.renderer.effect.EffectManager;
import com.ardor3d.renderer.effect.EffectStep;
import com.ardor3d.renderer.effect.RenderTarget;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.TextureState;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class EffectStep_RenderScreenOverlay
implements EffectStep {
    private final EnumMap<RenderState.StateType, RenderState> _states = new EnumMap(RenderState.StateType.class);
    private final TextureState _texState = new TextureState();
    private final Map<String, Integer> _targetMap = new HashMap<String, Integer>();

    public EffectStep_RenderScreenOverlay() {
        this._states.put(RenderState.StateType.Texture, this._texState);
    }

    @Override
    public void apply(EffectManager manager) {
        for (String key : this._targetMap.keySet()) {
            RenderTarget target = manager.getRenderTarget(key);
            Integer unit = this._targetMap.get(key);
            this._texState.setTexture(target.getTexture(), unit);
        }
        manager.renderFullScreenQuad(this._states);
    }

    public TextureState getTextureState() {
        return this._texState;
    }

    public EnumMap<RenderState.StateType, RenderState> getEnforcedStates() {
        return this._states;
    }

    public Map<String, Integer> getTargetMap() {
        return this._targetMap;
    }
}

