/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.effect;

import com.ardor3d.image.Texture;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.effect.EffectManager;
import com.ardor3d.renderer.effect.RenderTarget;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.scenegraph.Spatial;
import java.util.EnumMap;
import java.util.List;

public class RenderTarget_Framebuffer
implements RenderTarget {
    @Override
    public void render(EffectManager effectManager, Camera camera, List<Spatial> spatials, EnumMap<RenderState.StateType, RenderState> enforcedStates) {
        this.render(effectManager.getCurrentRenderer(), camera, spatials, null, enforcedStates);
    }

    @Override
    public void render(EffectManager effectManager, Camera camera, Spatial spatial, EnumMap<RenderState.StateType, RenderState> enforcedStates) {
        this.render(effectManager.getCurrentRenderer(), camera, null, spatial, enforcedStates);
    }

    public void render(Renderer renderer, Camera camera, List<Spatial> spatials, Spatial spatial, EnumMap<RenderState.StateType, RenderState> enforcedStates) {
        if (camera != Camera.getCurrentCamera()) {
            camera.update();
        }
        camera.apply(renderer);
        RenderContext context = ContextManager.getCurrentContext();
        context.enforceStates(enforcedStates);
        if (spatial != null) {
            spatial.onDraw(renderer);
        } else {
            for (Spatial spat : spatials) {
                spat.onDraw(renderer);
            }
        }
        renderer.renderBuckets();
        context.clearEnforcedStates();
    }

    @Override
    public Texture getTexture() {
        throw new UnsupportedOperationException();
    }
}

