/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.effect;

import com.ardor3d.image.Texture;
import com.ardor3d.image.Texture2D;
import com.ardor3d.image.TextureStoreFormat;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.TextureRenderer;
import com.ardor3d.renderer.effect.EffectManager;
import com.ardor3d.renderer.effect.RenderTarget;
import com.ardor3d.renderer.effect.TextureRendererPool;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.scenegraph.Spatial;
import java.util.EnumMap;
import java.util.List;

public class RenderTarget_Texture2D
implements RenderTarget {
    private final Texture2D _texture = new Texture2D();
    private final int _width;
    private final int _height;
    private boolean _texSetup = false;
    private final ColorRGBA _backgroundColor = new ColorRGBA(ColorRGBA.BLACK_NO_ALPHA);

    public RenderTarget_Texture2D(int width, int height) {
        this(width, height, TextureStoreFormat.RGB8);
    }

    public RenderTarget_Texture2D(int width, int height, TextureStoreFormat format) {
        this._width = width;
        this._height = height;
        this._texture.setTextureStoreFormat(format);
    }

    @Override
    public void render(EffectManager effectManager, Camera camera, List<Spatial> spatials, EnumMap<RenderState.StateType, RenderState> enforcedStates) {
        this.render(effectManager.getCurrentRenderer(), camera, spatials, null, enforcedStates);
    }

    @Override
    public void render(EffectManager effectManager, Camera camera, Spatial spatial, EnumMap<RenderState.StateType, RenderState> enforcedStates) {
        this.render(effectManager.getCurrentRenderer(), camera, null, spatial, enforcedStates);
    }

    protected void render(Renderer renderer, Camera camera, List<Spatial> spatials, Spatial spatial, EnumMap<RenderState.StateType, RenderState> enforcedStates) {
        TextureRenderer texRend = TextureRendererPool.fetch(this._width, this._height, renderer);
        if (!this._texSetup) {
            texRend.setupTexture(this._texture);
            this._texSetup = true;
        }
        texRend.setBackgroundColor((ReadOnlyColorRGBA)this._backgroundColor);
        if (camera != null) {
            texRend.getCamera().setFrame(camera);
            texRend.getCamera().setFrustum(camera);
            texRend.getCamera().setProjectionMode(camera.getProjectionMode());
        }
        texRend.enforceStates(enforcedStates);
        if (spatial != null) {
            texRend.render(spatial, (Texture)this._texture, 3);
        } else {
            texRend.render(spatials, (Texture)this._texture, 3);
        }
        texRend.clearEnforcedStates();
        TextureRendererPool.release(texRend);
    }

    @Override
    public Texture2D getTexture() {
        return this._texture;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public ReadOnlyColorRGBA getBackgroundColor() {
        return this._backgroundColor;
    }

    public void setBackgroundColor(ReadOnlyColorRGBA color) {
        this._backgroundColor.set(color);
    }
}

