/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.effect;

import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.TextureRenderer;
import com.ardor3d.renderer.TextureRendererFactory;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public enum TextureRendererPool {
    INSTANCE;

    private final List<TextureRenderer> renderers = new LinkedList<TextureRenderer>();

    public static TextureRenderer fetch(int width, int height, Renderer renderer) {
        Iterator<TextureRenderer> it = TextureRendererPool.INSTANCE.renderers.iterator();
        while (it.hasNext()) {
            TextureRenderer texRend = it.next();
            if (texRend.getWidth() != width || texRend.getHeight() != height) continue;
            it.remove();
            return texRend;
        }
        return TextureRendererFactory.INSTANCE.createTextureRenderer(width, height, renderer, ContextManager.getCurrentContext().getCapabilities());
    }

    public static void release(TextureRenderer texRend) {
        TextureRendererPool.INSTANCE.renderers.add(texRend);
    }
}

