/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.pass;

import com.ardor3d.image.Texture;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.TextureRenderer;
import com.ardor3d.renderer.pass.Pass;
import java.util.ArrayList;
import java.util.List;

public class BasicPassManager {
    protected List<Pass> _passes = new ArrayList<Pass>();

    public void add(Pass toAdd) {
        if (toAdd != null) {
            this._passes.add(toAdd);
        }
    }

    public void insert(Pass toAdd, int index) {
        this._passes.add(index, toAdd);
    }

    public boolean contains(Pass s) {
        return this._passes.contains(s);
    }

    public boolean remove(Pass toRemove) {
        return this._passes.remove(toRemove);
    }

    public Pass get(int index) {
        return this._passes.get(index);
    }

    public int passes() {
        return this._passes.size();
    }

    public void clearAll() {
        this.cleanUp();
        this._passes.clear();
    }

    public void cleanUp() {
        int sSize = this._passes.size();
        for (int i = 0; i < sSize; ++i) {
            Pass p = this._passes.get(i);
            p.cleanUp();
        }
    }

    public void renderPasses(Renderer r) {
        int sSize = this._passes.size();
        for (int i = 0; i < sSize; ++i) {
            Pass p = this._passes.get(i);
            p.renderPass(r);
        }
    }

    public void renderPasses(TextureRenderer r, int clear, List<Texture> texs) {
        int sSize = this._passes.size();
        for (int i = 0; i < sSize; ++i) {
            Pass p = this._passes.get(i);
            p.renderPass(r, clear, texs);
        }
    }

    public void updatePasses(double tpf) {
        int sSize = this._passes.size();
        for (int i = 0; i < sSize; ++i) {
            Pass p = this._passes.get(i);
            p.updatePass(tpf);
        }
    }
}

