/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.pass;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.pass.RenderPass;
import com.ardor3d.renderer.state.BlendState;
import com.ardor3d.renderer.state.CullState;
import com.ardor3d.renderer.state.LightState;
import com.ardor3d.renderer.state.TextureState;
import com.ardor3d.renderer.state.WireframeState;

public class OutlinePass
extends RenderPass {
    private static final long serialVersionUID = 1L;
    public static final float DEFAULT_LINE_WIDTH = 3.0f;
    public static final ReadOnlyColorRGBA DEFAULT_OUTLINE_COLOR = new ColorRGBA(ColorRGBA.BLACK);
    private final CullState _frontCull;
    private final CullState _backCull;
    private final WireframeState _wireframeState = new WireframeState();
    private final LightState _noLights;
    private final TextureState _noTexture;
    private BlendState _blendState;

    public OutlinePass(boolean antialiased) {
        this._wireframeState.setFace(WireframeState.Face.FrontAndBack);
        this._wireframeState.setLineWidth(3.0f);
        this._wireframeState.setEnabled(true);
        this._frontCull = new CullState();
        this._frontCull.setCullFace(CullState.Face.Front);
        this._backCull = new CullState();
        this._backCull.setCullFace(CullState.Face.Back);
        this._wireframeState.setAntialiased(antialiased);
        this._noLights = new LightState();
        this._noLights.setGlobalAmbient(DEFAULT_OUTLINE_COLOR);
        this._noLights.setEnabled(true);
        this._noTexture = new TextureState();
        this._noTexture.setEnabled(true);
        this._blendState = new BlendState();
        this._blendState.setSourceFunction(BlendState.SourceFunction.SourceAlpha);
        this._blendState.setDestinationFunction(BlendState.DestinationFunction.OneMinusSourceAlpha);
        this._blendState.setBlendEnabled(true);
        this._blendState.setEnabled(true);
    }

    @Override
    public void doRender(Renderer renderer) {
        if (this._spatials.size() == 0) {
            return;
        }
        this._context.enforceState(this._frontCull);
        super.doRender(renderer);
        this._context.enforceState(this._backCull);
        this._context.enforceState(this._wireframeState);
        this._context.enforceState(this._noLights);
        this._context.enforceState(this._noTexture);
        this._context.enforceState(this._blendState);
        super.doRender(renderer);
        this._context.clearEnforcedStates();
    }

    public void setOutlineWidth(float width) {
        this._wireframeState.setLineWidth(width);
    }

    public float getOutlineWidth() {
        return this._wireframeState.getLineWidth();
    }

    public void setOutlineColor(ReadOnlyColorRGBA outlineColor) {
        this._noLights.setGlobalAmbient(outlineColor);
    }

    public ReadOnlyColorRGBA getOutlineColor() {
        return this._noLights.getGlobalAmbient();
    }

    public BlendState getBlendState() {
        return this._blendState;
    }

    public void setBlendState(BlendState alphaState) {
        this._blendState = alphaState;
    }
}

