/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.pass;

import com.ardor3d.image.Texture;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.TextureRenderer;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.scenegraph.Spatial;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

public abstract class Pass
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected List<Spatial> _spatials = new ArrayList<Spatial>();
    protected boolean _enabled = true;
    protected final EnumMap<RenderState.StateType, RenderState> _passStates = new EnumMap(RenderState.StateType.class);
    protected RenderContext _context = null;

    public final void renderPass(Renderer r) {
        if (!this._enabled) {
            return;
        }
        this._context = ContextManager.getCurrentContext();
        this._context.pushEnforcedStates();
        this._context.enforceStates(this._passStates);
        this.doRender(r);
        this._context.popEnforcedStates();
        this._context = null;
    }

    public final void renderPass(TextureRenderer r, int clear, List<Texture> texs) {
        if (!this._enabled) {
            return;
        }
        this._context = ContextManager.getCurrentContext();
        this._context.pushEnforcedStates();
        this._context.enforceStates(this._passStates);
        this.doRender(r, clear, texs);
        this._context.popEnforcedStates();
        this._context = null;
    }

    public void setPassState(RenderState state) {
        this._passStates.put(state.getType(), state);
    }

    public void clearPassState(RenderState.StateType type) {
        this._passStates.remove((Object)type);
    }

    public void clearPassStates() {
        this._passStates.clear();
    }

    protected abstract void doRender(Renderer var1);

    protected void doRender(TextureRenderer r, int clear, List<Texture> texs) {
        throw new UnsupportedOperationException("This pass type does not support RTT use.");
    }

    public final void updatePass(double tpf) {
        if (!this._enabled) {
            return;
        }
        this.doUpdate(tpf);
    }

    protected void doUpdate(double tpf) {
    }

    public void add(Spatial toAdd) {
        this._spatials.add(toAdd);
    }

    public Spatial get(int index) {
        return this._spatials.get(index);
    }

    public boolean contains(Spatial s) {
        return this._spatials.contains(s);
    }

    public boolean remove(Spatial toRemove) {
        return this._spatials.remove(toRemove);
    }

    public int size() {
        return this._spatials.size();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void cleanUp() {
    }
}

