/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.queue;

import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.queue.RenderBucket;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.util.SortUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Stack;

public class AbstractRenderBucket
implements RenderBucket {
    protected Comparator<Spatial> _comparator;
    protected Spatial[] _currentList;
    protected Spatial[] _tempList;
    protected int _currentListSize;
    protected Stack<Spatial[]> _listStack = new Stack();
    protected Stack<Spatial[]> _listStackPool = new Stack();
    protected Stack<Integer> _listSizeStack = new Stack();

    public AbstractRenderBucket() {
        this._currentList = new Spatial[32];
        this._tempList = new Spatial[this._currentList.length];
    }

    @Override
    public void add(Spatial spatial) {
        spatial._queueDistance = Double.NEGATIVE_INFINITY;
        if (this._currentListSize >= this._currentList.length) {
            Spatial[] temp = new Spatial[this._currentListSize * 2];
            System.arraycopy(this._currentList, 0, temp, 0, this._currentListSize);
            this._currentList = temp;
            if (this._tempList.length < temp.length) {
                this._tempList = new Spatial[temp.length];
            }
        }
        this._currentList[this._currentListSize++] = spatial;
    }

    @Override
    public void remove(Spatial spatial) {
        int i;
        int index = 0;
        for (i = 0; i < this._currentListSize && this._currentList[index] != spatial; ++i) {
            ++index;
        }
        for (i = index; i < this._currentListSize - 1; ++i) {
            this._currentList[i] = this._currentList[i + 1];
        }
        --this._currentListSize;
    }

    @Override
    public void clear() {
        if (this._currentListSize > 0) {
            Arrays.fill(this._currentList, 0, this._currentListSize, null);
            this._currentListSize = 0;
        }
    }

    @Override
    public void render(Renderer renderer) {
        for (int i = 0; i < this._currentListSize; ++i) {
            this._currentList[i].draw(renderer);
        }
    }

    @Override
    public void sort() {
        if (this._currentListSize > 1) {
            if (this._currentListSize <= SortUtil.SHELL_SORT_THRESHOLD) {
                SortUtil.shellSort(this._currentList, 0, this._currentListSize - 1, this._comparator);
            } else {
                System.arraycopy(this._currentList, 0, this._tempList, 0, this._currentListSize);
                SortUtil.msort(this._tempList, this._currentList, 0, this._currentListSize - 1, this._comparator);
                Arrays.fill(this._tempList, 0, this._currentListSize, null);
            }
        }
    }

    @Override
    public void pushBucket() {
        this._listStack.push(this._currentList);
        this._currentList = this._listStackPool.isEmpty() ? new Spatial[32] : this._listStackPool.pop();
        this._listSizeStack.push(this._currentListSize);
        this._currentListSize = 0;
    }

    @Override
    public void popBucket() {
        if (this._currentList != null) {
            this._listStackPool.push(this._currentList);
        }
        this._currentList = this._listStack.pop();
        this._currentListSize = this._listSizeStack.pop();
    }

    protected double distanceToCam(Spatial spat) {
        ReadOnlyVector3 spatPosition;
        if (spat._queueDistance != Double.NEGATIVE_INFINITY) {
            return spat._queueDistance;
        }
        Camera cam = Camera.getCurrentCamera();
        spat._queueDistance = spat.getWorldBound() != null && Vector3.isValid((ReadOnlyVector3)spat.getWorldBound().getCenter()) ? spat.getWorldBound().distanceToEdge(cam.getLocation()) : (!Vector3.isValid((ReadOnlyVector3)(spatPosition = spat.getWorldTranslation())) ? Double.POSITIVE_INFINITY : cam.getLocation().distance(spatPosition));
        return spat._queueDistance;
    }
}

