/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.queue;

import com.ardor3d.renderer.queue.AbstractRenderBucket;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.TextureState;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.util.TextureKey;
import java.util.Comparator;

public class OpaqueRenderBucket
extends AbstractRenderBucket {
    public OpaqueRenderBucket() {
        this._comparator = new OpaqueComparator();
    }

    private class OpaqueComparator
    implements Comparator<Spatial> {
        private OpaqueComparator() {
        }

        @Override
        public int compare(Spatial o1, Spatial o2) {
            double d2;
            if (o1 instanceof Mesh && o2 instanceof Mesh) {
                return this.compareByStates((Mesh)o1, (Mesh)o2);
            }
            double d1 = OpaqueRenderBucket.this.distanceToCam(o1);
            if (d1 > (d2 = OpaqueRenderBucket.this.distanceToCam(o2))) {
                return 1;
            }
            if (d1 < d2) {
                return -1;
            }
            return 0;
        }

        private int compareByStates(Mesh mesh1, Mesh mesh2) {
            TextureState ts1 = (TextureState)mesh1.getWorldRenderState(RenderState.StateType.Texture);
            TextureState ts2 = (TextureState)mesh2.getWorldRenderState(RenderState.StateType.Texture);
            if (ts1 == null) {
                if (ts2 == null) {
                    return 0;
                }
                return -1;
            }
            if (ts2 == null) {
                return 1;
            }
            if (ts1 == ts2) {
                return 0;
            }
            int maxIndex = Math.min(ts1.getMaxTextureIndexUsed(), ts2.getMaxTextureIndexUsed());
            for (int x = 0; x <= maxIndex; ++x) {
                int tid2;
                TextureKey key1 = ts1.getTextureKey(x);
                TextureKey key2 = ts2.getTextureKey(x);
                if (key1 == null) {
                    if (key2 == null) continue;
                    return -1;
                }
                if (key2 == null) {
                    return 1;
                }
                int tid1 = key1.hashCode();
                if (tid1 == (tid2 = key2.hashCode())) continue;
                if (tid1 < tid2) {
                    return -1;
                }
                return 1;
            }
            if (ts1.getMaxTextureIndexUsed() != ts2.getMaxTextureIndexUsed()) {
                return ts2.getMaxTextureIndexUsed() - ts1.getMaxTextureIndexUsed();
            }
            return 0;
        }
    }
}

