/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.queue;

import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.queue.AbstractRenderBucket;
import com.ardor3d.scenegraph.Spatial;
import java.util.Comparator;

public class OrthoRenderBucket
extends AbstractRenderBucket {
    public OrthoRenderBucket() {
        this._comparator = new OrthoComparator();
    }

    @Override
    public void render(Renderer renderer) {
        if (this._currentListSize > 0) {
            try {
                renderer.setOrtho();
                for (int i = 0; i < this._currentListSize; ++i) {
                    this._currentList[i].draw(renderer);
                }
            }
            finally {
                renderer.unsetOrtho();
            }
        }
    }

    private static class OrthoComparator
    implements Comparator<Spatial> {
        private OrthoComparator() {
        }

        @Override
        public int compare(Spatial o1, Spatial o2) {
            if (o2.getSceneHints().getOrthoOrder() == o1.getSceneHints().getOrthoOrder()) {
                return 0;
            }
            if (o2.getSceneHints().getOrthoOrder() < o1.getSceneHints().getOrthoOrder()) {
                return -1;
            }
            return 1;
        }
    }
}

