/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.queue;

import java.util.HashMap;
import java.util.Map;

public final class RenderBucketType {
    private static final Map<String, RenderBucketType> bucketTypeMap = new HashMap<String, RenderBucketType>();
    private final String name;
    public static final RenderBucketType Inherit = RenderBucketType.getRenderBucketType("Inherit");
    public static final RenderBucketType PreBucket = RenderBucketType.getRenderBucketType("PreBucket");
    public static final RenderBucketType Shadow = RenderBucketType.getRenderBucketType("Shadow");
    public static final RenderBucketType Opaque = RenderBucketType.getRenderBucketType("Opaque");
    public static final RenderBucketType Transparent = RenderBucketType.getRenderBucketType("Transparent");
    public static final RenderBucketType Ortho = RenderBucketType.getRenderBucketType("Ortho");
    public static final RenderBucketType PostBucket = RenderBucketType.getRenderBucketType("PostBucket");
    public static final RenderBucketType Skip = RenderBucketType.getRenderBucketType("Skip");

    public static RenderBucketType getRenderBucketType(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null!");
        }
        RenderBucketType bucketType = bucketTypeMap.get(name);
        if (bucketType == null) {
            bucketType = new RenderBucketType(name);
            bucketTypeMap.put(name, bucketType);
        }
        return bucketType;
    }

    private RenderBucketType(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }
}

