/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.queue;

import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.queue.OpaqueRenderBucket;
import com.ardor3d.renderer.queue.OrthoRenderBucket;
import com.ardor3d.renderer.queue.RenderBucket;
import com.ardor3d.renderer.queue.RenderBucketType;
import com.ardor3d.renderer.queue.TransparentRenderBucket;
import com.ardor3d.scenegraph.InstancingManager;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.util.Ardor3dException;
import com.ardor3d.util.Constants;
import java.util.LinkedHashMap;
import java.util.Map;

public class RenderQueue {
    private final Map<RenderBucketType, RenderBucket> renderBuckets = new LinkedHashMap<RenderBucketType, RenderBucket>();

    public RenderQueue() {
        this.setupDefaultBuckets();
    }

    public void setupBuckets(RenderBucketType[] renderBucketTypes, RenderBucket[] buckets) {
        if (renderBucketTypes.length != buckets.length) {
            throw new Ardor3dException("Can't setup buckets, RenderBucketType and RenderBucket counts don't match.");
        }
        this.removeRenderBuckets();
        for (int i = 0; i < renderBucketTypes.length; ++i) {
            this.setRenderBucket(renderBucketTypes[i], buckets[i]);
        }
    }

    private void setupDefaultBuckets() {
        this.setRenderBucket(RenderBucketType.PreBucket, new OpaqueRenderBucket());
        this.setRenderBucket(RenderBucketType.Shadow, new OpaqueRenderBucket());
        this.setRenderBucket(RenderBucketType.Opaque, new OpaqueRenderBucket());
        this.setRenderBucket(RenderBucketType.Transparent, new TransparentRenderBucket());
        this.setRenderBucket(RenderBucketType.Ortho, new OrthoRenderBucket());
        this.setRenderBucket(RenderBucketType.PostBucket, new OpaqueRenderBucket());
    }

    public void removeRenderBuckets() {
        this.renderBuckets.clear();
    }

    public void removeRenderBucket(RenderBucketType type) {
        this.renderBuckets.remove(type);
    }

    public void setRenderBucket(RenderBucketType type, RenderBucket renderBucket) {
        this.renderBuckets.put(type, renderBucket);
    }

    public RenderBucket getRenderBucket(RenderBucketType type) {
        return this.renderBuckets.get(type);
    }

    public void addToQueue(Spatial spatial, RenderBucketType type) {
        if (type == RenderBucketType.Inherit || type == RenderBucketType.Skip) {
            throw new Ardor3dException("Can't add spatial to bucket of type: " + type);
        }
        if (Constants.enableInstancedGeometrySupport && this.prepareForInstancing(spatial)) {
            return;
        }
        RenderBucket renderBucket = this.getRenderBucket(type);
        if (renderBucket == null) {
            throw new Ardor3dException("No bucket exists of type: " + type);
        }
        renderBucket.add(spatial);
    }

    private final boolean prepareForInstancing(Spatial spatial) {
        Mesh mesh;
        InstancingManager instancing;
        boolean skipRenderQueue = false;
        if (spatial instanceof Mesh && (instancing = (mesh = (Mesh)spatial).getMeshData().getInstancingManager()) != null) {
            skipRenderQueue = instancing.isAddedToRenderQueue();
            instancing.registerMesh(mesh);
        }
        return skipRenderQueue;
    }

    public void removeFromQueue(Spatial spatial, RenderBucketType type) {
        if (type == RenderBucketType.Inherit || type == RenderBucketType.Skip) {
            throw new Ardor3dException("Can't remove spatial from bucket of type: " + type);
        }
        RenderBucket renderBucket = this.getRenderBucket(type);
        if (renderBucket == null) {
            throw new Ardor3dException("No bucket exists of type: " + type);
        }
        renderBucket.remove(spatial);
    }

    public void clearBuckets() {
        for (RenderBucket renderBucket : this.renderBuckets.values()) {
            renderBucket.clear();
        }
    }

    public void sortBuckets() {
        for (RenderBucket renderBucket : this.renderBuckets.values()) {
            renderBucket.sort();
        }
    }

    public void renderOnly(Renderer renderer) {
        for (RenderBucket renderBucket : this.renderBuckets.values()) {
            renderBucket.render(renderer);
        }
    }

    public void renderBuckets(Renderer renderer) {
        for (RenderBucket renderBucket : this.renderBuckets.values()) {
            renderBucket.sort();
            renderBucket.render(renderer);
            renderBucket.clear();
        }
    }

    public void pushBuckets() {
        for (RenderBucket renderBucket : this.renderBuckets.values()) {
            renderBucket.pushBucket();
        }
    }

    public void popBuckets() {
        for (RenderBucket renderBucket : this.renderBuckets.values()) {
            renderBucket.popBucket();
        }
    }
}

