/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.queue;

import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.queue.AbstractRenderBucket;
import com.ardor3d.renderer.state.CullState;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.ZBufferState;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.hint.TransparencyType;
import java.util.Comparator;

public class TransparentRenderBucket
extends AbstractRenderBucket {
    private final CullState _tranparentCull = new CullState();
    private final ZBufferState _transparentZBuff = new ZBufferState();

    public TransparentRenderBucket() {
        this._transparentZBuff.setWritable(false);
        this._transparentZBuff.setFunction(ZBufferState.TestFunction.LessThanOrEqualTo);
        this._comparator = new TransparentComparator();
    }

    @Override
    public void render(Renderer renderer) {
        RenderContext context = ContextManager.getCurrentContext();
        for (int i = 0; i < this._currentListSize; ++i) {
            TransparencyType renderType;
            Spatial spatial = this._currentList[i];
            if (spatial == null) continue;
            if (spatial instanceof Mesh && (renderType = spatial.getSceneHints().getTransparencyType()) != TransparencyType.OnePass) {
                RenderState setState;
                Mesh mesh = (Mesh)spatial;
                RenderState renderState = setState = context.hasEnforcedStates() ? context.getEnforcedState(RenderState.StateType.Cull) : null;
                if (setState == null) {
                    setState = mesh.getWorldRenderState(RenderState.StateType.Cull);
                }
                if (setState == null || ((CullState)setState).getCullFace() == CullState.Face.None) {
                    RenderState oldCullState = context.getEnforcedState(RenderState.StateType.Cull);
                    RenderState oldZState = context.getEnforcedState(RenderState.StateType.ZBuffer);
                    context.enforceState(this._tranparentCull);
                    context.enforceState(this._transparentZBuff);
                    this._tranparentCull.setCullFace(CullState.Face.Front);
                    mesh.draw(renderer);
                    context.clearEnforcedState(RenderState.StateType.ZBuffer);
                    if (oldZState != null) {
                        context.enforceState(oldZState);
                    }
                    this._tranparentCull.setCullFace(CullState.Face.Back);
                    mesh.draw(renderer);
                    if (oldCullState != null) {
                        context.enforceState(oldCullState);
                        continue;
                    }
                    context.clearEnforcedState(RenderState.StateType.Cull);
                    continue;
                }
            }
            spatial.draw(renderer);
        }
    }

    private class TransparentComparator
    implements Comparator<Spatial> {
        private TransparentComparator() {
        }

        @Override
        public int compare(Spatial o1, Spatial o2) {
            double d2;
            double d1 = TransparentRenderBucket.this.distanceToCam(o1);
            if (d1 > (d2 = TransparentRenderBucket.this.distanceToCam(o2))) {
                return -1;
            }
            if (d1 < d2) {
                return 1;
            }
            return 0;
        }
    }
}

