/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.BlendStateRecord;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;

public class BlendState
extends RenderState {
    private boolean _blendEnabled = false;
    private ColorRGBA _constantColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private SourceFunction _sourceFunctionRGB = SourceFunction.SourceAlpha;
    private DestinationFunction _destinationFunctionRGB = DestinationFunction.OneMinusSourceAlpha;
    private BlendEquation _blendEquationRGB = BlendEquation.Add;
    private SourceFunction _sourceFunctionAlpha = SourceFunction.SourceAlpha;
    private DestinationFunction _destinationFunctionAlpha = DestinationFunction.OneMinusSourceAlpha;
    private BlendEquation _blendEquationAlpha = BlendEquation.Add;
    private boolean _testEnabled = false;
    private TestFunction _testFunction = TestFunction.GreaterThan;
    private float _reference = 0.0f;
    private boolean _sampleAlphaToCoverageEnabled = false;
    private boolean _sampleAlphaToOneEnabled = false;
    private boolean _sampleCoverageEnabled = false;
    private float _sampleCoverage = 1.0f;
    private boolean _sampleCoverageInverted = false;

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.Blend;
    }

    public boolean isBlendEnabled() {
        return this._blendEnabled;
    }

    public void setBlendEnabled(boolean value) {
        this._blendEnabled = value;
        this.setNeedsRefresh(true);
    }

    public void setSourceFunction(SourceFunction function) {
        this.setSourceFunctionRGB(function);
        this.setSourceFunctionAlpha(function);
    }

    public void setSourceFunctionRGB(SourceFunction function) {
        if (function == null) {
            throw new IllegalArgumentException("function can not be null.");
        }
        this._sourceFunctionRGB = function;
        this.setNeedsRefresh(true);
    }

    public void setSourceFunctionAlpha(SourceFunction function) {
        if (function == null) {
            throw new IllegalArgumentException("function can not be null.");
        }
        this._sourceFunctionAlpha = function;
        this.setNeedsRefresh(true);
    }

    public SourceFunction getSourceFunctionRGB() {
        return this._sourceFunctionRGB;
    }

    public SourceFunction getSourceFunctionAlpha() {
        return this._sourceFunctionAlpha;
    }

    public void setDestinationFunction(DestinationFunction function) {
        this.setDestinationFunctionRGB(function);
        this.setDestinationFunctionAlpha(function);
    }

    public void setDestinationFunctionRGB(DestinationFunction function) {
        if (function == null) {
            throw new IllegalArgumentException("function can not be null.");
        }
        this._destinationFunctionRGB = function;
        this.setNeedsRefresh(true);
    }

    public void setDestinationFunctionAlpha(DestinationFunction function) {
        if (function == null) {
            throw new IllegalArgumentException("function can not be null.");
        }
        this._destinationFunctionAlpha = function;
        this.setNeedsRefresh(true);
    }

    public DestinationFunction getDestinationFunctionRGB() {
        return this._destinationFunctionRGB;
    }

    public DestinationFunction getDestinationFunctionAlpha() {
        return this._destinationFunctionAlpha;
    }

    public void setBlendEquation(BlendEquation blendEquation) {
        this.setBlendEquationRGB(blendEquation);
        this.setBlendEquationAlpha(blendEquation);
    }

    public void setBlendEquationRGB(BlendEquation blendEquation) {
        if (blendEquation == null) {
            throw new IllegalArgumentException("blendEquation can not be null.");
        }
        this._blendEquationRGB = blendEquation;
    }

    public void setBlendEquationAlpha(BlendEquation blendEquation) {
        if (blendEquation == null) {
            throw new IllegalArgumentException("blendEquation can not be null.");
        }
        this._blendEquationAlpha = blendEquation;
    }

    public BlendEquation getBlendEquationRGB() {
        return this._blendEquationRGB;
    }

    public BlendEquation getBlendEquationAlpha() {
        return this._blendEquationAlpha;
    }

    public boolean isTestEnabled() {
        return this._testEnabled;
    }

    public void setTestEnabled(boolean value) {
        this._testEnabled = value;
        this.setNeedsRefresh(true);
    }

    public void setTestFunction(TestFunction function) {
        if (function == null) {
            throw new IllegalArgumentException("function can not be null.");
        }
        this._testFunction = function;
        this.setNeedsRefresh(true);
    }

    public TestFunction getTestFunction() {
        return this._testFunction;
    }

    public void setReference(float reference) {
        if (reference < 0.0f) {
            reference = 0.0f;
        }
        if (reference > 1.0f) {
            reference = 1.0f;
        }
        this._reference = reference;
        this.setNeedsRefresh(true);
    }

    public float getReference() {
        return this._reference;
    }

    public ReadOnlyColorRGBA getConstantColor() {
        return this._constantColor;
    }

    public void setConstantColor(ReadOnlyColorRGBA constantColor) {
        this._constantColor.set(constantColor);
    }

    public boolean isSampleAlphaToCoverageEnabled() {
        return this._sampleAlphaToCoverageEnabled;
    }

    public void setSampleAlphaToCoverageEnabled(boolean sampleAlphaToCoverageEnabled) {
        this._sampleAlphaToCoverageEnabled = sampleAlphaToCoverageEnabled;
    }

    public boolean isSampleAlphaToOneEnabled() {
        return this._sampleAlphaToOneEnabled;
    }

    public void setSampleAlphaToOneEnabled(boolean sampleAlphaToOneEnabled) {
        this._sampleAlphaToOneEnabled = sampleAlphaToOneEnabled;
    }

    public boolean isSampleCoverageEnabled() {
        return this._sampleCoverageEnabled;
    }

    public void setSampleCoverageEnabled(boolean sampleCoverageEnabled) {
        this._sampleCoverageEnabled = sampleCoverageEnabled;
    }

    public float getSampleCoverage() {
        return this._sampleCoverage;
    }

    public void setSampleCoverage(float value) {
        if (value > 1.0f || value < 0.0f) {
            throw new IllegalArgumentException("value must be in range [0f, 1f]");
        }
        this._sampleCoverage = value;
    }

    public boolean isSampleCoverageInverted() {
        return this._sampleCoverageInverted;
    }

    public void setSampleCoverageInverted(boolean sampleCoverageInverted) {
        this._sampleCoverageInverted = sampleCoverageInverted;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._blendEnabled, "blendEnabled", false);
        capsule.write((Enum)this._sourceFunctionRGB, "sourceFunctionRGB", (Enum)SourceFunction.SourceAlpha);
        capsule.write((Enum)this._destinationFunctionRGB, "destinationFunctionRGB", (Enum)DestinationFunction.OneMinusSourceAlpha);
        capsule.write((Enum)this._blendEquationRGB, "blendEquationRGB", (Enum)BlendEquation.Add);
        capsule.write((Enum)this._sourceFunctionAlpha, "sourceFunctionAlpha", (Enum)SourceFunction.SourceAlpha);
        capsule.write((Enum)this._destinationFunctionAlpha, "destinationFunctionAlpha", (Enum)DestinationFunction.OneMinusSourceAlpha);
        capsule.write((Enum)this._blendEquationAlpha, "blendEquationAlpha", (Enum)BlendEquation.Add);
        capsule.write(this._testEnabled, "testEnabled", false);
        capsule.write((Enum)this._testFunction, "test", (Enum)TestFunction.GreaterThan);
        capsule.write(this._reference, "reference", 0.0f);
        capsule.write((Savable)this._constantColor, "constantColor", null);
        capsule.write(this._sampleAlphaToCoverageEnabled, "sampleAlphaToCoverageEnabled", false);
        capsule.write(this._sampleAlphaToOneEnabled, "sampleAlphaToOneEnabled", false);
        capsule.write(this._sampleCoverageEnabled, "sampleCoverageEnabled", false);
        capsule.write(this._sampleCoverageInverted, "sampleCoverageInverted", false);
        capsule.write(this._sampleCoverage, "sampleCoverage", 1.0f);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._blendEnabled = capsule.readBoolean("blendEnabled", false);
        this._sourceFunctionRGB = (SourceFunction)capsule.readEnum("sourceFunctionRGB", SourceFunction.class, (Enum)SourceFunction.SourceAlpha);
        this._destinationFunctionRGB = (DestinationFunction)capsule.readEnum("destinationFunctionRGB", DestinationFunction.class, (Enum)DestinationFunction.OneMinusSourceAlpha);
        this._blendEquationRGB = (BlendEquation)capsule.readEnum("blendEquationRGB", BlendEquation.class, (Enum)BlendEquation.Add);
        this._sourceFunctionAlpha = (SourceFunction)capsule.readEnum("sourceFunctionAlpha", SourceFunction.class, (Enum)SourceFunction.SourceAlpha);
        this._destinationFunctionAlpha = (DestinationFunction)capsule.readEnum("destinationFunctionAlpha", DestinationFunction.class, (Enum)DestinationFunction.OneMinusSourceAlpha);
        this._blendEquationAlpha = (BlendEquation)capsule.readEnum("blendEquationAlpha", BlendEquation.class, (Enum)BlendEquation.Add);
        this._testEnabled = capsule.readBoolean("testEnabled", false);
        this._testFunction = (TestFunction)capsule.readEnum("test", TestFunction.class, (Enum)TestFunction.GreaterThan);
        this._reference = capsule.readFloat("reference", 0.0f);
        this._constantColor = (ColorRGBA)capsule.readSavable("constantColor", null);
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new BlendStateRecord();
    }

    public static enum BlendEquation {
        Add,
        Subtract,
        ReverseSubtract,
        Min,
        Max;

    }

    public static enum TestFunction {
        Never,
        Always,
        EqualTo,
        NotEqualTo,
        LessThan,
        LessThanOrEqualTo,
        GreaterThan,
        GreaterThanOrEqualTo;

    }

    public static enum DestinationFunction {
        Zero(false),
        One(false),
        SourceColor(false),
        OneMinusSourceColor(false),
        SourceAlpha(false),
        OneMinusSourceAlpha(false),
        DestinationAlpha(false),
        OneMinusDestinationAlpha(false),
        ConstantColor(true),
        OneMinusConstantColor(true),
        ConstantAlpha(true),
        OneMinusConstantAlpha(true);

        private boolean usesConstantColor;

        private DestinationFunction(boolean usesConstantColor) {
            this.usesConstantColor = usesConstantColor;
        }

        public boolean usesConstantColor() {
            return this.usesConstantColor;
        }
    }

    public static enum SourceFunction {
        Zero(false),
        One(false),
        DestinationColor(false),
        OneMinusDestinationColor(false),
        SourceAlpha(false),
        OneMinusSourceAlpha(false),
        DestinationAlpha(false),
        OneMinusDestinationAlpha(false),
        SourceAlphaSaturate(false),
        ConstantColor(true),
        OneMinusConstantColor(true),
        ConstantAlpha(true),
        OneMinusConstantAlpha(true);

        private boolean usesConstantColor;

        private SourceFunction(boolean usesConstantColor) {
            this.usesConstantColor = usesConstantColor;
        }

        public boolean usesConstantColor() {
            return this.usesConstantColor;
        }
    }
}

