/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.ClipStateRecord;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import java.io.IOException;

public class ClipState
extends RenderState {
    public static final int MAX_CLIP_PLANES = 6;
    protected boolean[] enabledClipPlanes = new boolean[6];
    protected double[][] planeEquations = new double[6][4];

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.Clip;
    }

    public void setEnableClipPlane(int planeIndex, boolean enabled) {
        if (planeIndex < 0 || planeIndex >= 6) {
            return;
        }
        this.enabledClipPlanes[planeIndex] = enabled;
        this.setNeedsRefresh(true);
    }

    public void setClipPlaneEquation(int planeIndex, double clipX, double clipY, double clipZ, double clipW) {
        if (planeIndex < 0 || planeIndex >= 6) {
            return;
        }
        this.planeEquations[planeIndex][0] = clipX;
        this.planeEquations[planeIndex][1] = clipY;
        this.planeEquations[planeIndex][2] = clipZ;
        this.planeEquations[planeIndex][3] = clipW;
        this.setNeedsRefresh(true);
    }

    public boolean getPlaneEnabled(int index) {
        return this.enabledClipPlanes[index];
    }

    public double[] getPlaneEquations(int plane) {
        return this.planeEquations[plane];
    }

    public double getPlaneEquation(int plane, int eqIndex) {
        return this.planeEquations[plane][eqIndex];
    }

    public void setPlaneEq(int plane, int eqIndex, double value) {
        this.planeEquations[plane][eqIndex] = value;
        this.setNeedsRefresh(true);
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this.enabledClipPlanes, "enabledClipPlanes", new boolean[6]);
        capsule.write(this.planeEquations, "planeEquations", new double[6][4]);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this.enabledClipPlanes = capsule.readBooleanArray("enabledClipPlanes", new boolean[6]);
        this.planeEquations = capsule.readDoubleArray2D("planeEquations", new double[6][4]);
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new ClipStateRecord(caps);
    }
}

