/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.CullStateRecord;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import java.io.IOException;

public class CullState
extends RenderState {
    private Face cullFace = Face.None;
    private PolygonWind polygonWind = PolygonWind.CounterClockWise;

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.Cull;
    }

    public void setCullFace(Face face) {
        this.cullFace = face;
        this.setNeedsRefresh(true);
    }

    public Face getCullFace() {
        return this.cullFace;
    }

    public void setPolygonWind(PolygonWind windOrder) {
        this.polygonWind = windOrder;
        this.setNeedsRefresh(true);
    }

    public PolygonWind getPolygonWind() {
        return this.polygonWind;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Enum)this.cullFace, "cullFace", (Enum)Face.None);
        capsule.write((Enum)this.polygonWind, "polygonWind", (Enum)PolygonWind.CounterClockWise);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this.cullFace = (Face)capsule.readEnum("cullFace", Face.class, (Enum)Face.None);
        this.polygonWind = (PolygonWind)capsule.readEnum("polygonWind", PolygonWind.class, (Enum)PolygonWind.CounterClockWise);
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new CullStateRecord();
    }

    public static enum PolygonWind {
        CounterClockWise,
        ClockWise;

    }

    public static enum Face {
        None,
        Front,
        Back,
        FrontAndBack;

    }
}

