/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.FogStateRecord;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;

public class FogState
extends RenderState {
    protected float start = 0.0f;
    protected float end = 1.0f;
    protected float density = 1.0f;
    protected final ColorRGBA color = new ColorRGBA();
    protected DensityFunction densityFunction = DensityFunction.Exponential;
    protected Quality quality = Quality.PerVertex;
    protected CoordinateSource source = CoordinateSource.Depth;

    public void setQuality(Quality quality) {
        if (quality == null) {
            throw new IllegalArgumentException("quality can not be null.");
        }
        this.quality = quality;
        this.setNeedsRefresh(true);
    }

    public void setDensityFunction(DensityFunction function) {
        if (function == null) {
            throw new IllegalArgumentException("function can not be null.");
        }
        this.densityFunction = function;
        this.setNeedsRefresh(true);
    }

    public void setColor(ReadOnlyColorRGBA color) {
        this.color.set(color);
        this.setNeedsRefresh(true);
    }

    public void setDensity(float density) {
        if (density < 0.0f) {
            density = 0.0f;
        }
        if (density > 1.0f) {
            density = 1.0f;
        }
        this.density = density;
        this.setNeedsRefresh(true);
    }

    public void setEnd(float end) {
        this.end = end;
        this.setNeedsRefresh(true);
    }

    public void setStart(float start) {
        this.start = start;
        this.setNeedsRefresh(true);
    }

    public void setSource(CoordinateSource source) {
        this.source = source;
    }

    public CoordinateSource getSource() {
        return this.source;
    }

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.Fog;
    }

    public Quality getQuality() {
        return this.quality;
    }

    public ReadOnlyColorRGBA getColor() {
        return this.color;
    }

    public float getDensity() {
        return this.density;
    }

    public DensityFunction getDensityFunction() {
        return this.densityFunction;
    }

    public float getEnd() {
        return this.end;
    }

    public float getStart() {
        return this.start;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this.start, "start", 0.0f);
        capsule.write(this.end, "end", 0.0f);
        capsule.write(this.density, "density", 0.0f);
        capsule.write((Savable)this.color, "color", (Savable)new ColorRGBA(ColorRGBA.WHITE));
        capsule.write((Enum)this.densityFunction, "densityFunction", (Enum)DensityFunction.Exponential);
        capsule.write((Enum)this.quality, "applyFunction", (Enum)Quality.PerPixel);
        capsule.write((Enum)this.source, "source", (Enum)CoordinateSource.Depth);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this.start = capsule.readFloat("start", 0.0f);
        this.end = capsule.readFloat("end", 0.0f);
        this.density = capsule.readFloat("density", 0.0f);
        this.color.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("color", (Savable)new ColorRGBA(ColorRGBA.WHITE))));
        this.densityFunction = (DensityFunction)capsule.readEnum("densityFunction", DensityFunction.class, (Enum)DensityFunction.Exponential);
        this.quality = (Quality)capsule.readEnum("applyFunction", Quality.class, (Enum)Quality.PerPixel);
        this.source = (CoordinateSource)capsule.readEnum("source", CoordinateSource.class, (Enum)CoordinateSource.Depth);
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new FogStateRecord();
    }

    public static enum Quality {
        PerVertex,
        PerPixel;

    }

    public static enum CoordinateSource {
        Depth,
        FogCoords;

    }

    public static enum DensityFunction {
        Linear,
        Exponential,
        ExponentialSquared;

    }
}

