/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.FragmentProgramStateRecord;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FragmentProgramState
extends RenderState {
    private static final Logger logger = Logger.getLogger(FragmentProgramState.class.getName());
    protected boolean usingParameters = false;
    protected float[][] parameters = new float[24][];
    protected ByteBuffer program;
    protected int _programID = -1;

    public void setParameter(float[] param, int paramID) {
        if (paramID < 0 || paramID > 23) {
            throw new IllegalArgumentException("Invalid parameter ID");
        }
        if (param != null && param.length != 4) {
            throw new IllegalArgumentException("Fragment program parameters must be of type float[4]");
        }
        this.usingParameters = true;
        this.parameters[paramID] = param;
        this.setNeedsRefresh(true);
    }

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.FragmentProgram;
    }

    public void load(URL file) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(16384);
             BufferedInputStream inputStream = new BufferedInputStream(file.openStream());){
            byte[] buffer = new byte[1024];
            int byteCount = -1;
            while ((byteCount = ((InputStream)inputStream).read(buffer)) > 0) {
                outputStream.write(buffer, 0, byteCount);
            }
            byte[] data = outputStream.toByteArray();
            ((InputStream)inputStream).close();
            this.program = BufferUtils.createByteBuffer(data.length);
            this.program.put(data);
            this.program.rewind();
            this._programID = -1;
            this.setNeedsRefresh(true);
        }
        catch (Exception e) {
            logger.severe("Could not load fragment program: " + e);
            logger.logp(Level.SEVERE, this.getClass().getName(), "load(URL)", "Exception", e);
        }
    }

    public void load(String programContents) {
        try {
            byte[] bytes = programContents.getBytes();
            this.program = BufferUtils.createByteBuffer(bytes.length);
            this.program.put(bytes);
            this.program.rewind();
            this._programID = -1;
            this.setNeedsRefresh(true);
        }
        catch (Exception e) {
            logger.severe("Could not load fragment program: " + e);
            logger.logp(Level.SEVERE, this.getClass().getName(), "load(URL)", "Exception", e);
        }
    }

    public ByteBuffer getProgramAsBuffer() {
        return this.program;
    }

    public int _getProgramID() {
        return this._programID;
    }

    public void _setProgramID(int id) {
        this._programID = id;
    }

    public boolean isUsingParameters() {
        return this.usingParameters;
    }

    public float[][] _getParameters() {
        return this.parameters;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.program == null) {
            s.writeInt(0);
        } else {
            s.writeInt(this.program.capacity());
            this.program.rewind();
            int len = this.program.capacity();
            for (int x = 0; x < len; ++x) {
                s.writeByte(this.program.get());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int len = s.readInt();
        if (len == 0) {
            this.program = null;
        } else {
            this.program = BufferUtils.createByteBuffer(len);
            for (int x = 0; x < len; ++x) {
                this.program.put(s.readByte());
            }
        }
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this.usingParameters, "usingParameters", false);
        capsule.write(this.parameters, "parameters", (float[][])new float[24][]);
        capsule.write(this.program, "program", null);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this.usingParameters = capsule.readBoolean("usingParameters", false);
        this.parameters = capsule.readFloatArray2D("parameters", (float[][])new float[24][]);
        this.program = capsule.readByteBuffer("program", null);
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new FragmentProgramStateRecord();
    }
}

