/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyMatrix3;
import com.ardor3d.math.type.ReadOnlyMatrix4;
import com.ardor3d.math.type.ReadOnlyQuaternion;
import com.ardor3d.math.type.ReadOnlyVector2;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.math.type.ReadOnlyVector4;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.state.GLSLShaderDataLogic;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.ShaderObjectsStateRecord;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.scenegraph.ByteBufferData;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.scenegraph.IntBufferData;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.ShortBufferData;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import com.ardor3d.util.shader.ShaderVariable;
import com.ardor3d.util.shader.uniformtypes.ShaderVariableFloat;
import com.ardor3d.util.shader.uniformtypes.ShaderVariableFloat2;
import com.ardor3d.util.shader.uniformtypes.ShaderVariableFloat3;
import com.ardor3d.util.shader.uniformtypes.ShaderVariableFloat4;
import com.ardor3d.util.shader.uniformtypes.ShaderVariableFloatArray;
import com.ardor3d.util.shader.uniformtypes.ShaderVariableInt;
import com.ardor3d.util.shader.uniformtypes.ShaderVariableInt2;
import com.ardor3d.util.shader.uniformtypes.ShaderVariableInt3;
import com.ardor3d.util.shader.uniformtypes.ShaderVariableInt4;
import com.ardor3d.util.shader.uniformtypes.ShaderVariableIntArray;
import com.ardor3d.util.shader.uniformtypes.ShaderVariableMatrix3;
import com.ardor3d.util.shader.uniformtypes.ShaderVariableMatrix4;
import com.ardor3d.util.shader.uniformtypes.ShaderVariableMatrix4Array;
import com.ardor3d.util.shader.uniformtypes.ShaderVariablePointerByte;
import com.ardor3d.util.shader.uniformtypes.ShaderVariablePointerFloat;
import com.ardor3d.util.shader.uniformtypes.ShaderVariablePointerFloatMatrix;
import com.ardor3d.util.shader.uniformtypes.ShaderVariablePointerInt;
import com.ardor3d.util.shader.uniformtypes.ShaderVariablePointerShort;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GLSLShaderObjectsState
extends RenderState {
    private static final Logger logger = Logger.getLogger(GLSLShaderObjectsState.class.getName());
    protected List<ShaderVariable> _shaderUniforms = new ArrayList<ShaderVariable>();
    protected List<ShaderVariable> _shaderAttributes = new ArrayList<ShaderVariable>();
    protected ByteBuffer _vertShader;
    protected ByteBuffer _fragShader;
    protected ByteBuffer _geomShader;
    protected ByteBuffer _tessControlShader;
    protected ByteBuffer _tessEvalShader;
    protected ByteBuffer _compShader;
    public GLSLShaderDataLogic _shaderDataLogic;
    public Mesh _mesh;
    public boolean _needSendShader = true;
    public int _programID = -1;
    public int _vertexShaderID = -1;
    public int _fragmentShaderID = -1;
    public int _geometryShaderID = -1;
    public int _tessellationControlShaderID = -1;
    public int _tessellationEvaluationShaderID = -1;
    public int _computeShaderID = -1;
    private boolean _useAttributeVBO;
    public String _vertexShaderName;
    public String _fragmentShaderName;
    public String _geometryShaderName;
    public String _tessellationControlShaderName;
    public String _tessellationEvaluationShaderName;
    public String _computeShaderName;

    public ByteBuffer getVertexShader() {
        return this._vertShader;
    }

    public ByteBuffer getFragmentShader() {
        return this._fragShader;
    }

    public ByteBuffer getGeometryShader() {
        return this._geomShader;
    }

    public ByteBuffer getTessellationControlShader() {
        return this._tessControlShader;
    }

    public ByteBuffer getTessellationEvaluationShader() {
        return this._tessEvalShader;
    }

    public ByteBuffer getComputeShader() {
        return this._compShader;
    }

    public void setVertexShader(InputStream stream) throws IOException {
        this.setVertexShader(stream, "");
    }

    public void setVertexShader(InputStream stream, String name) throws IOException {
        this.setVertexShader(this.load(stream));
        this._vertexShaderName = name;
    }

    public void setFragmentShader(InputStream stream) throws IOException {
        this.setFragmentShader(stream, "");
    }

    public void setFragmentShader(InputStream stream, String name) throws IOException {
        this.setFragmentShader(this.load(stream));
        this._fragmentShaderName = name;
    }

    public void setGeometryShader(InputStream stream) throws IOException {
        this.setGeometryShader(stream, "");
    }

    public void setGeometryShader(InputStream stream, String name) throws IOException {
        this.setGeometryShader(this.load(stream));
        this._geometryShaderName = name;
    }

    public void setTessellationControlShader(InputStream stream) throws IOException {
        this.setTessellationControlShader(stream, "");
    }

    public void setTessellationControlShader(InputStream stream, String name) throws IOException {
        this.setTessellationControlShader(this.load(stream));
        this._tessellationControlShaderName = name;
    }

    public void setTessellationEvaluationShader(InputStream stream) throws IOException {
        this.setTessellationEvaluationShader(stream, "");
    }

    public void setTessellationEvaluationShader(InputStream stream, String name) throws IOException {
        this.setTessellationEvaluationShader(this.load(stream));
        this._tessellationEvaluationShaderName = name;
    }

    public void setComputeShader(InputStream stream) throws IOException {
        this.setComputeShader(stream, "");
    }

    public void setComputeShader(InputStream stream, String name) throws IOException {
        this.setComputeShader(this.load(stream));
        this._computeShaderName = name;
    }

    /*
     * Exception decompiling
     */
    protected ByteBuffer load(InputStream in) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setVertexShader(ByteBuffer shader) {
        this.setVertexShader(shader, "");
    }

    public void setVertexShader(ByteBuffer shader, String name) {
        this._vertShader = shader;
        this._vertexShaderName = name;
    }

    public void setFragmentShader(ByteBuffer shader) {
        this.setFragmentShader(shader, "");
    }

    public void setFragmentShader(ByteBuffer shader, String name) {
        this._fragShader = shader;
        this._fragmentShaderName = name;
    }

    public void setGeometryShader(ByteBuffer shader) {
        this.setGeometryShader(shader, "");
    }

    public void setGeometryShader(ByteBuffer shader, String name) {
        this._geomShader = shader;
        this._geometryShaderName = name;
    }

    public void setTessellationControlShader(ByteBuffer shader) {
        this.setTessellationControlShader(shader, "");
    }

    public void setTessellationControlShader(ByteBuffer shader, String name) {
        this._tessControlShader = shader;
        this._tessellationControlShaderName = name;
    }

    public void setTessellationEvaluationShader(ByteBuffer shader) {
        this.setTessellationEvaluationShader(shader, "");
    }

    public void setTessellationEvaluationShader(ByteBuffer shader, String name) {
        this._tessEvalShader = shader;
        this._tessellationEvaluationShaderName = name;
    }

    public void setComputeShader(ByteBuffer shader) {
        this.setComputeShader(shader, "");
    }

    public void setComputeShader(ByteBuffer shader, String name) {
        this._compShader = shader;
        this._computeShaderName = name;
    }

    public void setVertexShader(String shader) {
        this.setVertexShader(shader, "");
    }

    public void setVertexShader(String shader, String name) {
        this._vertShader = this.stringToByteBuffer(shader);
        this._vertexShaderName = name;
    }

    public void setFragmentShader(String shader) {
        this.setFragmentShader(shader, "");
    }

    public void setFragmentShader(String shader, String name) {
        this._fragShader = this.stringToByteBuffer(shader);
        this._fragmentShaderName = name;
    }

    public void setGeometryShader(String shader) {
        this.setGeometryShader(shader, "");
    }

    public void setGeometryShader(String shader, String name) {
        this._geomShader = this.stringToByteBuffer(shader);
        this._geometryShaderName = name;
    }

    public void setTessellationControlShader(String shader) {
        this.setTessellationControlShader(shader, "");
    }

    public void setTessellationControlShader(String shader, String name) {
        this._tessControlShader = this.stringToByteBuffer(shader);
        this._tessellationControlShaderName = name;
    }

    public void setTessellationEvaluationShader(String shader) {
        this.setTessellationEvaluationShader(shader, "");
    }

    public void setTessellationEvaluationShader(String shader, String name) {
        this._tessEvalShader = this.stringToByteBuffer(shader);
        this._tessellationEvaluationShaderName = name;
    }

    public void setComputeShader(String shader) {
        this.setComputeShader(shader, "");
    }

    public void setComputeShader(String shader, String name) {
        this._compShader = this.stringToByteBuffer(shader);
        this._computeShaderName = name;
    }

    private ByteBuffer stringToByteBuffer(String str) {
        byte[] bytes = str.getBytes();
        ByteBuffer buf = BufferUtils.createByteBuffer(bytes.length);
        buf.put(bytes);
        buf.rewind();
        return buf;
    }

    public List<ShaderVariable> getShaderUniforms() {
        return this._shaderUniforms;
    }

    public ShaderVariable getUniformByName(String uniformName) {
        for (ShaderVariable shaderVar : this._shaderUniforms) {
            if (!shaderVar.name.equals(uniformName)) continue;
            return shaderVar;
        }
        return null;
    }

    public List<ShaderVariable> getShaderAttributes() {
        return this._shaderAttributes;
    }

    public ShaderVariable getAttributeByName(String attributeName) {
        for (ShaderVariable shaderVar : this._shaderAttributes) {
            if (!shaderVar.name.equals(attributeName)) continue;
            return shaderVar;
        }
        return null;
    }

    public void setMesh(Mesh mesh) {
        this._mesh = mesh;
    }

    public void setShaderDataLogic(GLSLShaderDataLogic shaderDataLogic) {
        this._shaderDataLogic = shaderDataLogic;
    }

    public GLSLShaderDataLogic getShaderDataLogic() {
        return this._shaderDataLogic;
    }

    public boolean isUseAttributeVBO() {
        return this._useAttributeVBO;
    }

    public void setUseAttributeVBO(boolean useAttributeVBO) {
        this._useAttributeVBO = useAttributeVBO;
    }

    public void setUniform(String name, boolean value) {
        ShaderVariableInt shaderUniform = this.getShaderUniform(name, ShaderVariableInt.class);
        shaderUniform.value1 = value ? 1 : 0;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, int value) {
        ShaderVariableInt shaderUniform = this.getShaderUniform(name, ShaderVariableInt.class);
        shaderUniform.value1 = value;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, float value) {
        ShaderVariableFloat shaderUniform = this.getShaderUniform(name, ShaderVariableFloat.class);
        shaderUniform.value1 = value;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, boolean value1, boolean value2) {
        ShaderVariableInt2 shaderUniform = this.getShaderUniform(name, ShaderVariableInt2.class);
        shaderUniform.value1 = value1 ? 1 : 0;
        shaderUniform.value2 = value2 ? 1 : 0;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, int value1, int value2) {
        ShaderVariableInt2 shaderUniform = this.getShaderUniform(name, ShaderVariableInt2.class);
        shaderUniform.value1 = value1;
        shaderUniform.value2 = value2;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, float value1, float value2) {
        ShaderVariableFloat2 shaderUniform = this.getShaderUniform(name, ShaderVariableFloat2.class);
        shaderUniform.value1 = value1;
        shaderUniform.value2 = value2;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, boolean value1, boolean value2, boolean value3) {
        ShaderVariableInt3 shaderUniform = this.getShaderUniform(name, ShaderVariableInt3.class);
        shaderUniform.value1 = value1 ? 1 : 0;
        shaderUniform.value2 = value2 ? 1 : 0;
        shaderUniform.value3 = value3 ? 1 : 0;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, int value1, int value2, int value3) {
        ShaderVariableInt3 shaderUniform = this.getShaderUniform(name, ShaderVariableInt3.class);
        shaderUniform.value1 = value1;
        shaderUniform.value2 = value2;
        shaderUniform.value3 = value3;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, float value1, float value2, float value3) {
        ShaderVariableFloat3 shaderUniform = this.getShaderUniform(name, ShaderVariableFloat3.class);
        shaderUniform.value1 = value1;
        shaderUniform.value2 = value2;
        shaderUniform.value3 = value3;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, boolean value1, boolean value2, boolean value3, boolean value4) {
        ShaderVariableInt4 shaderUniform = this.getShaderUniform(name, ShaderVariableInt4.class);
        shaderUniform.value1 = value1 ? 1 : 0;
        shaderUniform.value2 = value2 ? 1 : 0;
        shaderUniform.value3 = value3 ? 1 : 0;
        shaderUniform.value4 = value4 ? 1 : 0;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, int value1, int value2, int value3, int value4) {
        ShaderVariableInt4 shaderUniform = this.getShaderUniform(name, ShaderVariableInt4.class);
        shaderUniform.value1 = value1;
        shaderUniform.value2 = value2;
        shaderUniform.value3 = value3;
        shaderUniform.value4 = value4;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, float value1, float value2, float value3, float value4) {
        ShaderVariableFloat4 shaderUniform = this.getShaderUniform(name, ShaderVariableFloat4.class);
        shaderUniform.value1 = value1;
        shaderUniform.value2 = value2;
        shaderUniform.value3 = value3;
        shaderUniform.value4 = value4;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, FloatBuffer value, int size) {
        assert (size >= 1 && size <= 4) : "Size must be 1, 2, 3 or 4";
        ShaderVariableFloatArray shaderUniform = this.getShaderUniform(name, ShaderVariableFloatArray.class);
        shaderUniform.value = value;
        shaderUniform.size = size;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, float[] value) {
        ShaderVariableFloatArray shaderUniform = this.getShaderUniform(name, ShaderVariableFloatArray.class);
        shaderUniform.value = BufferUtils.createFloatBuffer(value);
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, IntBuffer value) {
        ShaderVariableIntArray shaderUniform = this.getShaderUniform(name, ShaderVariableIntArray.class);
        shaderUniform.value = value;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, int[] value) {
        ShaderVariableIntArray shaderUniform = this.getShaderUniform(name, ShaderVariableIntArray.class);
        shaderUniform.value = BufferUtils.createIntBuffer(value);
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, ReadOnlyVector2 value) {
        ShaderVariableFloat2 shaderUniform = this.getShaderUniform(name, ShaderVariableFloat2.class);
        shaderUniform.value1 = (float)value.getX();
        shaderUniform.value2 = (float)value.getY();
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, ReadOnlyVector3 value) {
        ShaderVariableFloat3 shaderUniform = this.getShaderUniform(name, ShaderVariableFloat3.class);
        shaderUniform.value1 = (float)value.getX();
        shaderUniform.value2 = (float)value.getY();
        shaderUniform.value3 = (float)value.getZ();
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, ReadOnlyVector4 value) {
        ShaderVariableFloat4 shaderUniform = this.getShaderUniform(name, ShaderVariableFloat4.class);
        shaderUniform.value1 = (float)value.getX();
        shaderUniform.value2 = (float)value.getY();
        shaderUniform.value3 = (float)value.getZ();
        shaderUniform.value4 = (float)value.getW();
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, ReadOnlyColorRGBA value) {
        ShaderVariableFloat4 shaderUniform = this.getShaderUniform(name, ShaderVariableFloat4.class);
        shaderUniform.value1 = value.getRed();
        shaderUniform.value2 = value.getGreen();
        shaderUniform.value3 = value.getBlue();
        shaderUniform.value4 = value.getAlpha();
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, ReadOnlyQuaternion value) {
        ShaderVariableFloat4 shaderUniform = this.getShaderUniform(name, ShaderVariableFloat4.class);
        shaderUniform.value1 = (float)value.getX();
        shaderUniform.value2 = (float)value.getY();
        shaderUniform.value3 = (float)value.getZ();
        shaderUniform.value4 = (float)value.getW();
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, ReadOnlyMatrix3 value, boolean rowMajor) {
        ShaderVariableMatrix3 shaderUniform = this.getShaderUniform(name, ShaderVariableMatrix3.class);
        shaderUniform.matrixBuffer.rewind();
        value.toFloatBuffer(shaderUniform.matrixBuffer);
        shaderUniform.matrixBuffer.rewind();
        shaderUniform.rowMajor = rowMajor;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, ReadOnlyMatrix4 value, boolean rowMajor) {
        ShaderVariableMatrix4 shaderUniform = this.getShaderUniform(name, ShaderVariableMatrix4.class);
        shaderUniform.matrixBuffer.rewind();
        value.toFloatBuffer(shaderUniform.matrixBuffer);
        shaderUniform.matrixBuffer.rewind();
        shaderUniform.rowMajor = rowMajor;
        this.setNeedsRefresh(true);
    }

    public void setUniformMatrix4(String name, FloatBuffer value) {
        ShaderVariableMatrix4 shaderUniform = this.getShaderUniform(name, ShaderVariableMatrix4.class);
        shaderUniform.matrixBuffer.rewind();
        shaderUniform.matrixBuffer.put(value);
        shaderUniform.matrixBuffer.rewind();
        value.rewind();
        shaderUniform.rowMajor = true;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String name, ReadOnlyMatrix4[] values, boolean rowMajor) {
        ShaderVariableMatrix4Array shaderUniform = this.getShaderUniform(name, ShaderVariableMatrix4Array.class);
        FloatBuffer matrixBuffer = shaderUniform.matrixBuffer;
        if (matrixBuffer == null || matrixBuffer.capacity() < values.length * 16) {
            shaderUniform.matrixBuffer = matrixBuffer = BufferUtils.createFloatBuffer(values.length * 16);
        }
        matrixBuffer.clear();
        for (ReadOnlyMatrix4 value : values) {
            value.toFloatBuffer(matrixBuffer);
        }
        matrixBuffer.flip();
        shaderUniform.rowMajor = rowMajor;
        this.setNeedsRefresh(true);
    }

    public void clearUniforms() {
        this._shaderUniforms.clear();
    }

    public void setAttributePointer(String name, int size, boolean normalized, int stride, FloatBufferData data) {
        ShaderVariablePointerFloat shaderUniform = this.getShaderAttribute(name, ShaderVariablePointerFloat.class);
        shaderUniform.size = size;
        shaderUniform.normalized = normalized;
        shaderUniform.stride = stride;
        shaderUniform.data = data;
        this.setNeedsRefresh(true);
    }

    public void setAttributePointerMatrix(String name, int size, boolean normalized, FloatBufferData data) {
        ShaderVariablePointerFloatMatrix shaderUniform = this.getShaderAttribute(name, ShaderVariablePointerFloatMatrix.class);
        shaderUniform.size = size;
        shaderUniform.normalized = normalized;
        shaderUniform.data = data;
        this.setNeedsRefresh(true);
    }

    public void setAttributePointer(String name, int size, boolean normalized, boolean unsigned, int stride, ByteBufferData data) {
        ShaderVariablePointerByte shaderUniform = this.getShaderAttribute(name, ShaderVariablePointerByte.class);
        shaderUniform.size = size;
        shaderUniform.normalized = normalized;
        shaderUniform.unsigned = unsigned;
        shaderUniform.stride = stride;
        shaderUniform.data = data;
        this.setNeedsRefresh(true);
    }

    public void setAttributePointer(String name, int size, boolean normalized, boolean unsigned, int stride, IntBufferData data) {
        ShaderVariablePointerInt shaderUniform = this.getShaderAttribute(name, ShaderVariablePointerInt.class);
        shaderUniform.size = size;
        shaderUniform.normalized = normalized;
        shaderUniform.unsigned = unsigned;
        shaderUniform.stride = stride;
        shaderUniform.data = data;
        this.setNeedsRefresh(true);
    }

    public void setAttributePointer(String name, int size, boolean normalized, boolean unsigned, int stride, ShortBufferData data) {
        ShaderVariablePointerShort shaderUniform = this.getShaderAttribute(name, ShaderVariablePointerShort.class);
        shaderUniform.size = size;
        shaderUniform.normalized = normalized;
        shaderUniform.unsigned = unsigned;
        shaderUniform.stride = stride;
        shaderUniform.data = data;
        this.setNeedsRefresh(true);
    }

    public void clearAttributes() {
        this._shaderAttributes.clear();
    }

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.GLSLShader;
    }

    private <T extends ShaderVariable> T getShaderUniform(String name, Class<T> classz) {
        T shaderVariable = this.getShaderVariable(name, classz, this._shaderUniforms);
        return shaderVariable;
    }

    private <T extends ShaderVariable> T getShaderAttribute(String name, Class<T> classz) {
        T shaderVariable = this.getShaderVariable(name, classz, this._shaderAttributes);
        this.checkAttributeSizeLimits();
        return shaderVariable;
    }

    private <T extends ShaderVariable> T getShaderVariable(String name, Class<T> classz, List<ShaderVariable> shaderVariableList) {
        int i = shaderVariableList.size();
        while (--i >= 0) {
            ShaderVariable temp = shaderVariableList.get(i);
            if (!name.equals(temp.name)) continue;
            temp.needsRefresh = true;
            return (T)temp;
        }
        try {
            ShaderVariable shaderUniform = (ShaderVariable)classz.newInstance();
            shaderUniform.name = name;
            shaderVariableList.add(shaderUniform);
            return (T)shaderUniform;
        }
        catch (InstantiationException e) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "getShaderVariable(name, classz, shaderVariableList)", "Exception", e);
        }
        catch (IllegalAccessException e) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "getShaderVariable(name, classz, shaderVariableList)", "Exception", e);
        }
        return null;
    }

    public void checkAttributeSizeLimits() {
        RenderContext context = ContextManager.getCurrentContext();
        ContextCapabilities caps = context.getCapabilities();
        if (this._shaderAttributes.size() > caps.getMaxGLSLVertexAttributes()) {
            logger.severe("Too many shader attributes(standard+defined): " + this._shaderAttributes.size() + " maximum: " + caps.getMaxGLSLVertexAttributes());
        }
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.writeSavableList(this._shaderUniforms, "shaderUniforms", new ArrayList());
        capsule.writeSavableList(this._shaderAttributes, "shaderAttributes", new ArrayList());
        capsule.write(this._vertShader, "vertShader", null);
        capsule.write(this._fragShader, "fragShader", null);
        capsule.write(this._geomShader, "geomShader", null);
        capsule.write(this._geomShader, "geomShader", null);
        capsule.write(this._tessControlShader, "tessControlShader", null);
        capsule.write(this._tessEvalShader, "tessEvalShader", null);
        capsule.write(this._useAttributeVBO, "useAttributeVBO", false);
        if (this._shaderDataLogic instanceof Savable) {
            capsule.write((Savable)this._shaderDataLogic, "shaderDataLogic", null);
        }
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._shaderUniforms = capsule.readSavableList("shaderUniforms", new ArrayList());
        this._shaderAttributes = capsule.readSavableList("shaderAttributes", new ArrayList());
        this._vertShader = capsule.readByteBuffer("vertShader", null);
        this._fragShader = capsule.readByteBuffer("fragShader", null);
        this._geomShader = capsule.readByteBuffer("geomShader", null);
        this._tessControlShader = capsule.readByteBuffer("tessControlShader", null);
        this._tessEvalShader = capsule.readByteBuffer("tessEvalShader", null);
        this._useAttributeVBO = capsule.readBoolean("useAttributeVBO", false);
        Savable shaderDataLogic = capsule.readSavable("shaderDataLogic", null);
        if (shaderDataLogic != null) {
            if (shaderDataLogic instanceof GLSLShaderDataLogic) {
                this._shaderDataLogic = (GLSLShaderDataLogic)shaderDataLogic;
            } else {
                logger.warning("Deserialized shaderDataLogic is not of type GLSLShaderDataLogic. " + shaderDataLogic.getClass().getName());
            }
        }
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new ShaderObjectsStateRecord();
    }
}

