/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.light.Light;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.LightStateRecord;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.hint.LightCombineMode;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class LightState
extends RenderState {
    public static boolean LIGHTS_ENABLED = true;
    public static final int MAX_LIGHTS_ALLOWED = 8;
    public static final int MASK_AMBIENT = 1;
    public static final int MASK_DIFFUSE = 2;
    public static final int MASK_SPECULAR = 4;
    public static final int MASK_GLOBALAMBIENT = 8;
    private List<Light> lightList;
    protected int lightMask = 0;
    protected int backLightMask = 0;
    protected boolean twoSidedOn = true;
    protected ColorRGBA _globalAmbient = new ColorRGBA(DEFAULT_GLOBAL_AMBIENT);
    public static final ReadOnlyColorRGBA DEFAULT_GLOBAL_AMBIENT = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    protected boolean localViewerOn;
    protected boolean separateSpecularOn;

    public LightState() {
        this.lightList = new ArrayList<Light>();
    }

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.Light;
    }

    public boolean attach(Light light) {
        if (!this.lightList.contains(light)) {
            this.lightList.add(light);
            this.setNeedsRefresh(true);
            return true;
        }
        return false;
    }

    public void detach(Light light) {
        this.lightList.remove(light);
        this.setNeedsRefresh(true);
    }

    public void detachAll() {
        this.lightList.clear();
        this.setNeedsRefresh(true);
    }

    public List<Light> getLightList() {
        return this.lightList;
    }

    public Light get(int i) {
        return this.lightList.get(i);
    }

    public int getNumberOfChildren() {
        return this.lightList.size() > 8 ? 8 : this.lightList.size();
    }

    public void setTwoSidedLighting(boolean twoSidedOn) {
        this.twoSidedOn = twoSidedOn;
        this.setNeedsRefresh(true);
    }

    public boolean getTwoSidedLighting() {
        return this.twoSidedOn;
    }

    public void setLocalViewer(boolean localViewerOn) {
        this.localViewerOn = localViewerOn;
        this.setNeedsRefresh(true);
    }

    public boolean getLocalViewer() {
        return this.localViewerOn;
    }

    public void setSeparateSpecular(boolean separateSpecularOn) {
        this.separateSpecularOn = separateSpecularOn;
        this.setNeedsRefresh(true);
    }

    public boolean getSeparateSpecular() {
        return this.separateSpecularOn;
    }

    public void setGlobalAmbient(ReadOnlyColorRGBA color) {
        this._globalAmbient.set(color);
        this.setNeedsRefresh(true);
    }

    public ReadOnlyColorRGBA getGlobalAmbient() {
        return this._globalAmbient;
    }

    public int getLightMask() {
        return this.lightMask;
    }

    public void setLightMask(int lightMask) {
        this.lightMask = lightMask;
        this.setNeedsRefresh(true);
    }

    public void pushLightMask() {
        this.backLightMask = this.lightMask;
    }

    public void popLightMask() {
        this.lightMask = this.backLightMask;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.writeSavableList(this.lightList, "lightList", new ArrayList());
        capsule.write(this.lightMask, "lightMask", 0);
        capsule.write(this.backLightMask, "backLightMask", 0);
        capsule.write(this.twoSidedOn, "twoSidedOn", false);
        capsule.write((Savable)this._globalAmbient, "globalAmbient", (Savable)new ColorRGBA(DEFAULT_GLOBAL_AMBIENT));
        capsule.write(this.localViewerOn, "localViewerOn", false);
        capsule.write(this.separateSpecularOn, "separateSpecularOn", false);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this.lightList = capsule.readSavableList("lightList", new ArrayList());
        this.lightMask = capsule.readInt("lightMask", 0);
        this.backLightMask = capsule.readInt("backLightMask", 0);
        this.twoSidedOn = capsule.readBoolean("twoSidedOn", false);
        this._globalAmbient = (ColorRGBA)capsule.readSavable("globalAmbient", (Savable)new ColorRGBA(DEFAULT_GLOBAL_AMBIENT));
        this.localViewerOn = capsule.readBoolean("localViewerOn", false);
        this.separateSpecularOn = capsule.readBoolean("separateSpecularOn", false);
    }

    @Override
    public RenderState extract(Stack<? extends RenderState> stack, Spatial spat) {
        if (spat == null) {
            return stack.peek();
        }
        LightCombineMode mode = spat.getSceneHints().getLightCombineMode();
        Mesh mesh = (Mesh)spat;
        LightState lightState = mesh.getLightState();
        if (lightState == null) {
            lightState = new LightState();
            mesh.setLightState(lightState);
        }
        lightState.detachAll();
        if (mode == LightCombineMode.Replace || mode != LightCombineMode.Off && stack.size() == 1) {
            LightState copyLightState = (LightState)stack.peek();
            LightState.copyLightState(copyLightState, lightState);
        } else {
            Object[] states = stack.toArray();
            boolean foundEnabled = false;
            block0 : switch (mode) {
                case CombineClosest: 
                case CombineClosestEnabled: {
                    for (int iIndex = states.length - 1; iIndex >= 0; --iIndex) {
                        LightState pkLState = (LightState)states[iIndex];
                        if (!pkLState.isEnabled()) {
                            if (mode != LightCombineMode.CombineClosestEnabled) continue;
                            break block0;
                        }
                        foundEnabled = true;
                        LightState.copyLightState(pkLState, lightState);
                    }
                    break;
                }
                case CombineFirst: {
                    int max = states.length;
                    for (int iIndex = 0; iIndex < max; ++iIndex) {
                        LightState pkLState = (LightState)states[iIndex];
                        if (!pkLState.isEnabled()) continue;
                        foundEnabled = true;
                        LightState.copyLightState(pkLState, lightState);
                    }
                    break;
                }
            }
            lightState.setEnabled(foundEnabled);
        }
        return lightState;
    }

    private static void copyLightState(LightState source, LightState destination) {
        destination.setTwoSidedLighting(source.getTwoSidedLighting());
        destination.setLocalViewer(source.getLocalViewer());
        destination.setSeparateSpecular(source.getSeparateSpecular());
        destination.setEnabled(source.isEnabled());
        destination.setGlobalAmbient(source.getGlobalAmbient());
        destination.setLightMask(source.getLightMask());
        destination.setNeedsRefresh(true);
        int maxL = source.getLightList().size();
        for (int i = 0; i < maxL; ++i) {
            Light pkLight = source.get(i);
            if (pkLight == null) continue;
            destination.attach(pkLight);
        }
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new LightStateRecord();
    }
}

