/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.light.Light;
import com.ardor3d.light.PointLight;
import com.ardor3d.light.SpotLight;
import com.ardor3d.math.Plane;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyPlane;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.Spatial;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class LightUtil {
    private static LightComparator lightComparator = new LightComparator();

    public static void sort(Mesh geometry, List<Light> lights) {
        lightComparator.setSpatial(geometry);
        Collections.sort(lights, lightComparator);
    }

    protected static double getValueFor(Light l, BoundingVolume val) {
        if (l == null || !l.isEnabled()) {
            return 0.0;
        }
        if (l.getType() == Light.Type.Directional) {
            return LightUtil.getColorValue(l);
        }
        if (l.getType() == Light.Type.Point) {
            return LightUtil.getValueFor((PointLight)l, val);
        }
        if (l.getType() == Light.Type.Spot) {
            return LightUtil.getValueFor((SpotLight)l, val);
        }
        return 0.3;
    }

    protected static double getValueFor(PointLight l, BoundingVolume val) {
        if (val == null) {
            return 0.0;
        }
        if (l.isAttenuate()) {
            ReadOnlyVector3 location = l.getLocation();
            double dist = val.distanceTo(location);
            double color = LightUtil.getColorValue(l);
            double amlat = (double)l.getConstant() + (double)l.getLinear() * dist + (double)l.getQuadratic() * dist * dist;
            return color / amlat;
        }
        return LightUtil.getColorValue(l);
    }

    protected static double getValueFor(SpotLight l, BoundingVolume val) {
        ReadOnlyVector3 location;
        if (val == null) {
            return 0.0;
        }
        ReadOnlyVector3 direction = l.getDirection();
        Plane p = new Plane(direction, direction.dot(location = l.getLocation()));
        if (val.whichSide((ReadOnlyPlane)p) != ReadOnlyPlane.Side.Inside) {
            return LightUtil.getValueFor((PointLight)l, val);
        }
        return 0.0;
    }

    protected static double getColorValue(Light l) {
        return LightUtil.strength(l.getAmbient()) + LightUtil.strength(l.getDiffuse());
    }

    protected static double strength(ReadOnlyColorRGBA color) {
        return Math.sqrt(color.getRed() * color.getRed() + color.getGreen() * color.getGreen() + color.getBlue() * color.getBlue());
    }

    private static class LightComparator
    implements Comparator<Light> {
        private Spatial _sp;

        private LightComparator() {
        }

        public void setSpatial(Spatial sp) {
            this._sp = sp;
        }

        @Override
        public int compare(Light l1, Light l2) {
            double v2;
            double v1 = LightUtil.getValueFor(l1, this._sp.getWorldBound());
            double cmp = v1 - (v2 = LightUtil.getValueFor(l2, this._sp.getWorldBound()));
            if (0.0 > cmp) {
                return 1;
            }
            if (0.0 < cmp) {
                return -1;
            }
            return 0;
        }
    }
}

