/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.MaterialStateRecord;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;

public class MaterialState
extends RenderState {
    public static final ReadOnlyColorRGBA DEFAULT_AMBIENT = new ColorRGBA(0.2f, 0.2f, 0.2f, 1.0f);
    public static final ReadOnlyColorRGBA DEFAULT_DIFFUSE = new ColorRGBA(0.8f, 0.8f, 0.8f, 1.0f);
    public static final ReadOnlyColorRGBA DEFAULT_SPECULAR = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    public static final ReadOnlyColorRGBA DEFAULT_EMISSIVE = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    public static final float DEFAULT_SHININESS = 0.0f;
    public static final ColorMaterial DEFAULT_COLOR_MATERIAL = ColorMaterial.None;
    public static final MaterialFace DEFAULT_COLOR_MATERIAL_FACE = MaterialFace.FrontAndBack;
    protected final ColorRGBA _frontAmbient = new ColorRGBA(DEFAULT_AMBIENT);
    protected final ColorRGBA _frontDiffuse = new ColorRGBA(DEFAULT_DIFFUSE);
    protected final ColorRGBA _frontSpecular = new ColorRGBA(DEFAULT_SPECULAR);
    protected final ColorRGBA _frontEmissive = new ColorRGBA(DEFAULT_EMISSIVE);
    protected float _frontShininess = 0.0f;
    protected final ColorRGBA _backAmbient = new ColorRGBA(DEFAULT_AMBIENT);
    protected final ColorRGBA _backDiffuse = new ColorRGBA(DEFAULT_DIFFUSE);
    protected final ColorRGBA _backSpecular = new ColorRGBA(DEFAULT_SPECULAR);
    protected final ColorRGBA _backEmissive = new ColorRGBA(DEFAULT_EMISSIVE);
    protected float _backShininess = 0.0f;
    protected ColorMaterial _colorMaterial = DEFAULT_COLOR_MATERIAL;
    protected MaterialFace _colorMaterialFace = DEFAULT_COLOR_MATERIAL_FACE;

    public ReadOnlyColorRGBA getAmbient() {
        return this._frontAmbient;
    }

    public ReadOnlyColorRGBA getBackAmbient() {
        return this._backAmbient;
    }

    public void setAmbient(ReadOnlyColorRGBA ambient) {
        this.setAmbient(MaterialFace.FrontAndBack, ambient);
    }

    public void setAmbient(MaterialFace face, ReadOnlyColorRGBA ambient) {
        if (face == MaterialFace.Front || face == MaterialFace.FrontAndBack) {
            this._frontAmbient.set(ambient);
        }
        if (face == MaterialFace.Back || face == MaterialFace.FrontAndBack) {
            this._backAmbient.set(ambient);
        }
        this.setNeedsRefresh(true);
    }

    public ReadOnlyColorRGBA getDiffuse() {
        return this._frontDiffuse;
    }

    public ReadOnlyColorRGBA getBackDiffuse() {
        return this._backDiffuse;
    }

    public void setDiffuse(ReadOnlyColorRGBA diffuse) {
        this.setDiffuse(MaterialFace.FrontAndBack, diffuse);
    }

    public void setDiffuse(MaterialFace face, ReadOnlyColorRGBA diffuse) {
        if (face == MaterialFace.Front || face == MaterialFace.FrontAndBack) {
            this._frontDiffuse.set(diffuse);
        }
        if (face == MaterialFace.Back || face == MaterialFace.FrontAndBack) {
            this._backDiffuse.set(diffuse);
        }
        this.setNeedsRefresh(true);
    }

    public ReadOnlyColorRGBA getEmissive() {
        return this._frontEmissive;
    }

    public ReadOnlyColorRGBA getBackEmissive() {
        return this._backEmissive;
    }

    public void setEmissive(ReadOnlyColorRGBA emissive) {
        this.setEmissive(MaterialFace.FrontAndBack, emissive);
    }

    public void setEmissive(MaterialFace face, ReadOnlyColorRGBA emissive) {
        if (face == MaterialFace.Front || face == MaterialFace.FrontAndBack) {
            this._frontEmissive.set(emissive);
        }
        if (face == MaterialFace.Back || face == MaterialFace.FrontAndBack) {
            this._backEmissive.set(emissive);
        }
        this.setNeedsRefresh(true);
    }

    public ReadOnlyColorRGBA getSpecular() {
        return this._frontSpecular;
    }

    public ReadOnlyColorRGBA getBackSpecular() {
        return this._backSpecular;
    }

    public void setSpecular(ReadOnlyColorRGBA specular) {
        this.setSpecular(MaterialFace.FrontAndBack, specular);
    }

    public void setSpecular(MaterialFace face, ReadOnlyColorRGBA specular) {
        if (face == MaterialFace.Front || face == MaterialFace.FrontAndBack) {
            this._frontSpecular.set(specular);
        }
        if (face == MaterialFace.Back || face == MaterialFace.FrontAndBack) {
            this._backSpecular.set(specular);
        }
        this.setNeedsRefresh(true);
    }

    public float getShininess() {
        return this._frontShininess;
    }

    public float getBackShininess() {
        return this._backShininess;
    }

    public void setShininess(float shininess) {
        this.setShininess(MaterialFace.FrontAndBack, shininess);
    }

    public void setShininess(MaterialFace face, float shininess) {
        if (shininess < 0.0f || shininess > 128.0f) {
            throw new IllegalArgumentException("Shininess must be between 0 and 128.");
        }
        if (face == MaterialFace.Front || face == MaterialFace.FrontAndBack) {
            this._frontShininess = shininess;
        }
        if (face == MaterialFace.Back || face == MaterialFace.FrontAndBack) {
            this._backShininess = shininess;
        }
        this.setNeedsRefresh(true);
    }

    public ColorMaterial getColorMaterial() {
        return this._colorMaterial;
    }

    public void setColorMaterial(ColorMaterial material) {
        if (material == null) {
            throw new IllegalArgumentException("material can not be null.");
        }
        this._colorMaterial = material;
        this.setNeedsRefresh(true);
    }

    public MaterialFace getColorMaterialFace() {
        return this._colorMaterialFace;
    }

    public void setColorMaterialFace(MaterialFace face) {
        if (face == null) {
            throw new IllegalArgumentException("face can not be null.");
        }
        this._colorMaterialFace = face;
        this.setNeedsRefresh(true);
    }

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.Material;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Savable)this._frontAmbient, "frontAmbient", (Savable)((ColorRGBA)DEFAULT_AMBIENT));
        capsule.write((Savable)this._frontDiffuse, "frontDiffuse", (Savable)((ColorRGBA)DEFAULT_DIFFUSE));
        capsule.write((Savable)this._frontSpecular, "frontSpecular", (Savable)((ColorRGBA)DEFAULT_SPECULAR));
        capsule.write((Savable)this._frontEmissive, "frontEmissive", (Savable)((ColorRGBA)DEFAULT_EMISSIVE));
        capsule.write(this._frontShininess, "frontShininess", 0.0f);
        capsule.write((Savable)this._backAmbient, "backAmbient", (Savable)((ColorRGBA)DEFAULT_AMBIENT));
        capsule.write((Savable)this._backDiffuse, "backDiffuse", (Savable)((ColorRGBA)DEFAULT_DIFFUSE));
        capsule.write((Savable)this._backSpecular, "backSpecular", (Savable)((ColorRGBA)DEFAULT_SPECULAR));
        capsule.write((Savable)this._backEmissive, "backEmissive", (Savable)((ColorRGBA)DEFAULT_EMISSIVE));
        capsule.write(this._backShininess, "backShininess", 0.0f);
        capsule.write((Enum)this._colorMaterial, "colorMaterial", (Enum)DEFAULT_COLOR_MATERIAL);
        capsule.write((Enum)this._colorMaterialFace, "colorMaterialFace", (Enum)DEFAULT_COLOR_MATERIAL_FACE);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._frontAmbient.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("frontAmbient", (Savable)((ColorRGBA)DEFAULT_AMBIENT))));
        this._frontDiffuse.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("frontDiffuse", (Savable)((ColorRGBA)DEFAULT_DIFFUSE))));
        this._frontSpecular.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("frontSpecular", (Savable)((ColorRGBA)DEFAULT_SPECULAR))));
        this._frontEmissive.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("frontEmissive", (Savable)((ColorRGBA)DEFAULT_EMISSIVE))));
        this._frontShininess = capsule.readFloat("frontShininess", 0.0f);
        this._backAmbient.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("backAmbient", (Savable)((ColorRGBA)DEFAULT_AMBIENT))));
        this._backDiffuse.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("backDiffuse", (Savable)((ColorRGBA)DEFAULT_DIFFUSE))));
        this._backSpecular.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("backSpecular", (Savable)((ColorRGBA)DEFAULT_SPECULAR))));
        this._backEmissive.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("backEmissive", (Savable)((ColorRGBA)DEFAULT_EMISSIVE))));
        this._backShininess = capsule.readFloat("backShininess", 0.0f);
        this._colorMaterial = (ColorMaterial)capsule.readEnum("colorMaterial", ColorMaterial.class, (Enum)DEFAULT_COLOR_MATERIAL);
        this._colorMaterialFace = (MaterialFace)capsule.readEnum("colorMaterialFace", MaterialFace.class, (Enum)DEFAULT_COLOR_MATERIAL_FACE);
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new MaterialStateRecord();
    }

    public static enum MaterialFace {
        Front,
        Back,
        FrontAndBack;

    }

    public static enum ColorMaterial {
        None,
        Ambient,
        Diffuse,
        AmbientAndDiffuse,
        Specular,
        Emissive;

    }
}

