/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.OffsetStateRecord;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import java.io.IOException;
import java.util.EnumSet;

public class OffsetState
extends RenderState {
    private final EnumSet<OffsetType> _enabledOffsets = EnumSet.noneOf(OffsetType.class);
    private float _factor;
    private float _units;

    public void setFactor(float factor) {
        this._factor = factor;
        this.setNeedsRefresh(true);
    }

    public float getFactor() {
        return this._factor;
    }

    public void setUnits(float units) {
        this._units = units;
        this.setNeedsRefresh(true);
    }

    public float getUnits() {
        return this._units;
    }

    public void setTypeEnabled(OffsetType type, boolean enabled) {
        if (enabled) {
            this._enabledOffsets.add(type);
        } else {
            this._enabledOffsets.remove((Object)type);
        }
        this.setNeedsRefresh(true);
    }

    public boolean isTypeEnabled(OffsetType type) {
        return this._enabledOffsets.contains((Object)type);
    }

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.Offset;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._factor, "factor", 0.0f);
        capsule.write(this._units, "units", 0.0f);
        capsule.write(this._enabledOffsets.contains((Object)OffsetType.Fill), "typeFill", false);
        capsule.write(this._enabledOffsets.contains((Object)OffsetType.Line), "typeLine", false);
        capsule.write(this._enabledOffsets.contains((Object)OffsetType.Point), "typePoint", false);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._factor = capsule.readFloat("factor", 0.0f);
        this._units = capsule.readFloat("units", 0.0f);
        this._enabledOffsets.clear();
        if (capsule.readBoolean("typeFill", false)) {
            this._enabledOffsets.add(OffsetType.Fill);
        }
        if (capsule.readBoolean("typeLine", false)) {
            this._enabledOffsets.add(OffsetType.Line);
        }
        if (capsule.readBoolean("typePoint", false)) {
            this._enabledOffsets.add(OffsetType.Point);
        }
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new OffsetStateRecord();
    }

    public static enum OffsetType {
        Fill,
        Line,
        Point;

    }
}

