/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.math.ObjectPool;
import com.ardor3d.math.Poolable;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.BlendState;
import com.ardor3d.renderer.state.ClipState;
import com.ardor3d.renderer.state.ColorMaskState;
import com.ardor3d.renderer.state.CullState;
import com.ardor3d.renderer.state.FogState;
import com.ardor3d.renderer.state.FragmentProgramState;
import com.ardor3d.renderer.state.GLSLShaderObjectsState;
import com.ardor3d.renderer.state.LightState;
import com.ardor3d.renderer.state.MaterialState;
import com.ardor3d.renderer.state.OffsetState;
import com.ardor3d.renderer.state.ShadingState;
import com.ardor3d.renderer.state.StencilState;
import com.ardor3d.renderer.state.TextureState;
import com.ardor3d.renderer.state.VertexProgramState;
import com.ardor3d.renderer.state.WireframeState;
import com.ardor3d.renderer.state.ZBufferState;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.util.Constants;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Stack;

public abstract class RenderState
implements Savable {
    public static final EnumSet<StateType> _quickCompare = EnumSet.noneOf(StateType.class);
    private static final ObjectPool<StateStack> STATESTACKS_POOL;
    private boolean _enabled = true;
    private boolean _needsRefresh = false;

    public abstract StateType getType();

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean value) {
        this._enabled = value;
        this.setNeedsRefresh(true);
    }

    public RenderState extract(Stack<? extends RenderState> stack, Spatial spat) {
        return stack.peek();
    }

    public void write(OutputCapsule capsule) throws IOException {
        capsule.write(this._enabled, "enabled", true);
    }

    public void read(InputCapsule capsule) throws IOException {
        this._enabled = capsule.readBoolean("enabled", true);
    }

    public Class<? extends RenderState> getClassTag() {
        return this.getClass();
    }

    public abstract StateRecord createStateRecord(ContextCapabilities var1);

    public boolean needsRefresh() {
        return this._needsRefresh;
    }

    public void setNeedsRefresh(boolean refresh) {
        this._needsRefresh = refresh;
    }

    public static void setQuickCompares(boolean enabled) {
        _quickCompare.clear();
        if (enabled) {
            _quickCompare.addAll(EnumSet.allOf(StateType.class));
        }
    }

    public static RenderState createState(StateType type) {
        switch (type) {
            case Blend: {
                return new BlendState();
            }
            case Clip: {
                return new ClipState();
            }
            case ColorMask: {
                return new ColorMaskState();
            }
            case Cull: {
                return new CullState();
            }
            case Fog: {
                return new FogState();
            }
            case FragmentProgram: {
                return new FragmentProgramState();
            }
            case GLSLShader: {
                return new GLSLShaderObjectsState();
            }
            case Light: {
                return new LightState();
            }
            case Material: {
                return new MaterialState();
            }
            case Offset: {
                return new OffsetState();
            }
            case Shading: {
                return new ShadingState();
            }
            case Stencil: {
                return new StencilState();
            }
            case Texture: {
                return new TextureState();
            }
            case VertexProgram: {
                return new VertexProgramState();
            }
            case Wireframe: {
                return new WireframeState();
            }
            case ZBuffer: {
                return new ZBufferState();
            }
        }
        throw new IllegalArgumentException("Unknown state type: " + (Object)((Object)type));
    }

    static {
        _quickCompare.add(StateType.Blend);
        _quickCompare.add(StateType.Fog);
        _quickCompare.add(StateType.Material);
        _quickCompare.add(StateType.Shading);
        _quickCompare.add(StateType.ZBuffer);
        _quickCompare.add(StateType.Cull);
        _quickCompare.add(StateType.VertexProgram);
        _quickCompare.add(StateType.FragmentProgram);
        _quickCompare.add(StateType.GLSLShader);
        _quickCompare.add(StateType.ColorMask);
        _quickCompare.add(StateType.Offset);
        STATESTACKS_POOL = ObjectPool.create(StateStack.class, (int)Constants.maxStatePoolSize);
    }

    public static class StateStack
    implements Poolable {
        private final EnumMap<StateType, Stack<RenderState>> stacks = new EnumMap(StateType.class);

        public static final StateStack fetchTempInstance() {
            if (Constants.useStatePools) {
                StateStack s = (StateStack)STATESTACKS_POOL.fetch();
                for (Stack<RenderState> stack : s.stacks.values()) {
                    stack.clear();
                }
                return s;
            }
            return new StateStack();
        }

        public static final void releaseTempInstance(StateStack s) {
            if (Constants.useStatePools) {
                STATESTACKS_POOL.release((Poolable)s);
            }
        }

        public void push(RenderState state) {
            Stack<RenderState> stack = this.stacks.get((Object)state.getType());
            if (stack == null) {
                stack = new Stack();
                this.stacks.put(state.getType(), stack);
            }
            stack.push(state);
        }

        public void pop(RenderState state) {
            Stack<RenderState> stack = this.stacks.get((Object)state.getType());
            stack.pop();
        }

        public void extract(EnumMap<StateType, RenderState> states, Spatial caller) {
            for (Stack<RenderState> stack : this.stacks.values()) {
                if (stack.isEmpty()) continue;
                RenderState state = stack.peek().extract(stack, caller);
                states.put(state.getType(), state);
            }
        }
    }

    public static enum StateType {
        Blend,
        Fog,
        Light,
        Material,
        Shading,
        Texture,
        Wireframe,
        ZBuffer,
        Cull,
        VertexProgram,
        FragmentProgram,
        Stencil,
        GLSLShader,
        ColorMask,
        Clip,
        Offset;

        public static StateType[] values;

        static {
            values = StateType.values();
        }
    }
}

