/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.ShadingStateRecord;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import java.io.IOException;

public class ShadingState
extends RenderState {
    protected ShadingMode _shadeMode = ShadingMode.Smooth;

    public ShadingMode getShadingMode() {
        return this._shadeMode;
    }

    public void setShadingMode(ShadingMode shadeMode) {
        if (shadeMode == null) {
            throw new IllegalArgumentException("shadeMode can not be null.");
        }
        this._shadeMode = shadeMode;
        this.setNeedsRefresh(true);
    }

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.Shading;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Enum)this._shadeMode, "shadeMode", (Enum)ShadingMode.Smooth);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._shadeMode = (ShadingMode)capsule.readEnum("shadeMode", ShadingMode.class, (Enum)ShadingMode.Smooth);
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new ShadingStateRecord();
    }

    public static enum ShadingMode {
        Flat,
        Smooth;

    }
}

