/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.renderer.state.record.StencilStateRecord;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import java.io.IOException;

public class StencilState
extends RenderState {
    private boolean _useTwoSided = false;
    private StencilFunction _stencilFunctionFront = StencilFunction.Always;
    private int _stencilReferenceFront = 0;
    private int _stencilFuncMaskFront = -1;
    private int _stencilWriteMaskFront = -1;
    private StencilOperation _stencilOpFailFront = StencilOperation.Keep;
    private StencilOperation _stencilOpZFailFront = StencilOperation.Keep;
    private StencilOperation _stencilOpZPassFront = StencilOperation.Keep;
    private StencilFunction _stencilFunctionBack = StencilFunction.Always;
    private int _stencilReferenceBack = 0;
    private int _stencilFuncMaskBack = -1;
    private int _stencilWriteMaskBack = -1;
    private StencilOperation _stencilOpFailBack = StencilOperation.Keep;
    private StencilOperation _stencilOpZFailBack = StencilOperation.Keep;
    private StencilOperation _stencilOpZPassBack = StencilOperation.Keep;

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.Stencil;
    }

    public void setStencilFunction(StencilFunction function) {
        this.setStencilFunctionFront(function);
        this.setStencilFunctionBack(function);
    }

    public void setStencilReference(int reference) {
        this.setStencilReferenceFront(reference);
        this.setStencilReferenceBack(reference);
    }

    public void setStencilMask(int mask) {
        this.setStencilMaskFront(mask);
        this.setStencilMaskBack(mask);
    }

    public void setStencilWriteMask(int mask) {
        this.setStencilWriteMaskFront(mask);
        this.setStencilWriteMaskBack(mask);
    }

    public void setStencilFuncMask(int mask) {
        this.setStencilFuncMaskFront(mask);
        this.setStencilFuncMaskBack(mask);
    }

    public void setStencilOpFail(StencilOperation operation) {
        this.setStencilOpFailFront(operation);
        this.setStencilOpFailBack(operation);
    }

    public void setStencilOpZFail(StencilOperation operation) {
        this.setStencilOpZFailFront(operation);
        this.setStencilOpZFailBack(operation);
    }

    public void setStencilOpZPass(StencilOperation operation) {
        this.setStencilOpZPassFront(operation);
        this.setStencilOpZPassBack(operation);
    }

    public void setStencilFunctionFront(StencilFunction function) {
        if (function == null) {
            throw new IllegalArgumentException("function can not be null.");
        }
        this._stencilFunctionFront = function;
        this.setNeedsRefresh(true);
    }

    public StencilFunction getStencilFunctionFront() {
        return this._stencilFunctionFront;
    }

    public void setStencilReferenceFront(int reference) {
        this._stencilReferenceFront = reference;
        this.setNeedsRefresh(true);
    }

    public int getStencilReferenceFront() {
        return this._stencilReferenceFront;
    }

    public void setStencilMaskFront(int mask) {
        this.setStencilWriteMaskFront(mask);
        this.setStencilFuncMaskFront(mask);
    }

    public void setStencilWriteMaskFront(int mask) {
        this._stencilWriteMaskFront = mask;
        this.setNeedsRefresh(true);
    }

    public int getStencilWriteMaskFront() {
        return this._stencilWriteMaskFront;
    }

    public void setStencilFuncMaskFront(int mask) {
        this._stencilFuncMaskFront = mask;
        this.setNeedsRefresh(true);
    }

    public int getStencilFuncMaskFront() {
        return this._stencilFuncMaskFront;
    }

    public void setStencilOpFailFront(StencilOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("operation can not be null.");
        }
        this._stencilOpFailFront = operation;
        this.setNeedsRefresh(true);
    }

    public StencilOperation getStencilOpFailFront() {
        return this._stencilOpFailFront;
    }

    public void setStencilOpZFailFront(StencilOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("operation can not be null.");
        }
        this._stencilOpZFailFront = operation;
        this.setNeedsRefresh(true);
    }

    public StencilOperation getStencilOpZFailFront() {
        return this._stencilOpZFailFront;
    }

    public void setStencilOpZPassFront(StencilOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("operation can not be null.");
        }
        this._stencilOpZPassFront = operation;
        this.setNeedsRefresh(true);
    }

    public StencilOperation getStencilOpZPassFront() {
        return this._stencilOpZPassFront;
    }

    public void setStencilFunctionBack(StencilFunction function) {
        if (function == null) {
            throw new IllegalArgumentException("function can not be null.");
        }
        this._stencilFunctionBack = function;
        this.setNeedsRefresh(true);
    }

    public StencilFunction getStencilFunctionBack() {
        return this._stencilFunctionBack;
    }

    public void setStencilReferenceBack(int reference) {
        this._stencilReferenceBack = reference;
        this.setNeedsRefresh(true);
    }

    public int getStencilReferenceBack() {
        return this._stencilReferenceBack;
    }

    public void setStencilMaskBack(int mask) {
        this.setStencilWriteMaskBack(mask);
        this.setStencilFuncMaskBack(mask);
    }

    public void setStencilWriteMaskBack(int mask) {
        this._stencilWriteMaskBack = mask;
        this.setNeedsRefresh(true);
    }

    public int getStencilWriteMaskBack() {
        return this._stencilWriteMaskBack;
    }

    public void setStencilFuncMaskBack(int mask) {
        this._stencilFuncMaskBack = mask;
        this.setNeedsRefresh(true);
    }

    public int getStencilFuncMaskBack() {
        return this._stencilFuncMaskBack;
    }

    public void setStencilOpFailBack(StencilOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("operation can not be null.");
        }
        this._stencilOpFailBack = operation;
        this.setNeedsRefresh(true);
    }

    public StencilOperation getStencilOpFailBack() {
        return this._stencilOpFailBack;
    }

    public void setStencilOpZFailBack(StencilOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("operation can not be null.");
        }
        this._stencilOpZFailBack = operation;
        this.setNeedsRefresh(true);
    }

    public StencilOperation getStencilOpZFailBack() {
        return this._stencilOpZFailBack;
    }

    public void setStencilOpZPassBack(StencilOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("operation can not be null.");
        }
        this._stencilOpZPassBack = operation;
        this.setNeedsRefresh(true);
    }

    public StencilOperation getStencilOpZPassBack() {
        return this._stencilOpZPassBack;
    }

    public boolean isUseTwoSided() {
        return this._useTwoSided;
    }

    public void setUseTwoSided(boolean useTwoSided) {
        this._useTwoSided = useTwoSided;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._useTwoSided, "useTwoSided", false);
        capsule.write((Enum)this._stencilFunctionFront, "stencilFuncFront", (Enum)StencilFunction.Always);
        capsule.write(this._stencilReferenceFront, "stencilRefFront", 0);
        capsule.write(this._stencilWriteMaskFront, "stencilWriteMaskFront", -1);
        capsule.write(this._stencilFuncMaskFront, "stencilFuncMaskFront", -1);
        capsule.write((Enum)this._stencilOpFailFront, "stencilOpFailFront", (Enum)StencilOperation.Keep);
        capsule.write((Enum)this._stencilOpZFailFront, "stencilOpZFailFront", (Enum)StencilOperation.Keep);
        capsule.write((Enum)this._stencilOpZPassFront, "stencilOpZPassFront", (Enum)StencilOperation.Keep);
        capsule.write((Enum)this._stencilFunctionBack, "stencilFuncBack", (Enum)StencilFunction.Always);
        capsule.write(this._stencilReferenceBack, "stencilRefBack", 0);
        capsule.write(this._stencilWriteMaskBack, "stencilWriteMaskBack", -1);
        capsule.write(this._stencilFuncMaskBack, "stencilFuncMaskBack", -1);
        capsule.write((Enum)this._stencilOpFailBack, "stencilOpFailBack", (Enum)StencilOperation.Keep);
        capsule.write((Enum)this._stencilOpZFailBack, "stencilOpZFailBack", (Enum)StencilOperation.Keep);
        capsule.write((Enum)this._stencilOpZPassBack, "stencilOpZPassBack", (Enum)StencilOperation.Keep);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._useTwoSided = capsule.readBoolean("useTwoSided", false);
        this._stencilFunctionFront = (StencilFunction)capsule.readEnum("stencilFuncFront", StencilFunction.class, (Enum)StencilFunction.Always);
        this._stencilReferenceFront = capsule.readInt("stencilRefFront", 0);
        this._stencilWriteMaskFront = capsule.readInt("stencilWriteMaskFront", -1);
        this._stencilFuncMaskFront = capsule.readInt("stencilFuncMaskFront", -1);
        this._stencilOpFailFront = (StencilOperation)capsule.readEnum("stencilOpFailFront", StencilOperation.class, (Enum)StencilOperation.Keep);
        this._stencilOpZFailFront = (StencilOperation)capsule.readEnum("stencilOpZFailFront", StencilOperation.class, (Enum)StencilOperation.Keep);
        this._stencilOpZPassFront = (StencilOperation)capsule.readEnum("stencilOpZPassFront", StencilOperation.class, (Enum)StencilOperation.Keep);
        this._stencilFunctionBack = (StencilFunction)capsule.readEnum("stencilFuncBack", StencilFunction.class, (Enum)StencilFunction.Always);
        this._stencilReferenceBack = capsule.readInt("stencilRefBack", 0);
        this._stencilWriteMaskBack = capsule.readInt("stencilWriteMaskBack", -1);
        this._stencilFuncMaskBack = capsule.readInt("stencilFuncMaskBack", -1);
        this._stencilOpFailBack = (StencilOperation)capsule.readEnum("stencilOpFailBack", StencilOperation.class, (Enum)StencilOperation.Keep);
        this._stencilOpZFailBack = (StencilOperation)capsule.readEnum("stencilOpZFailBack", StencilOperation.class, (Enum)StencilOperation.Keep);
        this._stencilOpZPassBack = (StencilOperation)capsule.readEnum("stencilOpZPassBack", StencilOperation.class, (Enum)StencilOperation.Keep);
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new StencilStateRecord();
    }

    public static enum StencilOperation {
        Keep,
        Zero,
        Replace,
        Increment,
        Decrement,
        IncrementWrap,
        DecrementWrap,
        Invert;

    }

    public static enum StencilFunction {
        Never,
        LessThan,
        LessThanOrEqualTo,
        GreaterThan,
        GreaterThanOrEqualTo,
        EqualTo,
        NotEqualTo,
        Always;

    }
}

