/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.image.Image;
import com.ardor3d.image.Texture;
import com.ardor3d.image.Texture2D;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.renderer.state.record.TextureStateRecord;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.hint.TextureCombineMode;
import com.ardor3d.util.TextureKey;
import com.ardor3d.util.TextureManager;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.resource.ResourceLocatorTool;
import com.ardor3d.util.resource.ResourceSource;
import com.ardor3d.util.resource.URLResourceSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextureState
extends RenderState {
    private static final Logger logger = Logger.getLogger(TextureState.class.getName());
    public static final int MAX_TEXTURES = 32;
    protected static Texture _defaultTexture = null;
    protected static boolean defaultTextureLoaded = false;
    protected List<Texture> _texture = new ArrayList<Texture>(1);
    private CorrectionType _correctionType = CorrectionType.Perspective;
    public transient TextureKey[] _keyCache = new TextureKey[32];
    public static ResourceSource DEFAULT_TEXTURE_SOURCE;

    public TextureState() {
        if (!defaultTextureLoaded) {
            TextureState.loadDefaultTexture();
        }
    }

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.Texture;
    }

    public void setTexture(Texture texture) {
        if (this._texture.size() == 0) {
            this._texture.add(texture);
        } else {
            this._texture.set(0, texture);
        }
        this.setNeedsRefresh(true);
    }

    public Texture getTexture() {
        if (this._texture.size() > 0) {
            return this._texture.get(0);
        }
        return null;
    }

    public void setTexture(Texture texture, int textureUnit) {
        if (textureUnit >= 0 && textureUnit < 32) {
            while (textureUnit >= this._texture.size()) {
                this._texture.add(null);
            }
            this._texture.set(textureUnit, texture);
        }
        this.setNeedsRefresh(true);
    }

    public Texture getTexture(int textureUnit) {
        if (textureUnit < this._texture.size() && textureUnit >= 0) {
            return this._texture.get(textureUnit);
        }
        return null;
    }

    public boolean removeTexture(Texture tex) {
        int index = this._texture.indexOf(tex);
        if (index == -1) {
            return false;
        }
        this._texture.set(index, null);
        this._keyCache[index] = null;
        return true;
    }

    public boolean removeTexture(int textureUnit) {
        if (textureUnit < 0 || textureUnit >= 32 || textureUnit >= this._texture.size()) {
            return false;
        }
        Texture t = this._texture.get(textureUnit);
        if (t == null) {
            return false;
        }
        this._texture.set(textureUnit, null);
        this._keyCache[textureUnit] = null;
        return true;
    }

    public void clearTextures() {
        int i = this._texture.size();
        while (--i >= 0) {
            this.removeTexture(i);
        }
    }

    public void setCorrectionType(CorrectionType type) {
        if (type == null) {
            throw new IllegalArgumentException("type can not be null.");
        }
        this._correctionType = type;
        this.setNeedsRefresh(true);
    }

    public CorrectionType getCorrectionType() {
        return this._correctionType;
    }

    public int getNumberOfSetTextures() {
        int set = 0;
        for (int i = 0; i < this._texture.size(); ++i) {
            if (this._texture.get(i) == null) continue;
            ++set;
        }
        return set;
    }

    public int getMaxTextureIndexUsed() {
        int max;
        for (max = this._texture.size() - 1; max > 0 && this._texture.get(max) == null; --max) {
        }
        return max;
    }

    public final TextureKey getTextureKey(int textureUnit) {
        if (textureUnit < this._keyCache.length && textureUnit >= 0) {
            return this._keyCache[textureUnit];
        }
        return null;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.writeSavableList(this._texture, "texture", new ArrayList(1));
        capsule.write((Enum)this._correctionType, "correctionType", (Enum)CorrectionType.Perspective);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._texture = capsule.readSavableList("texture", new ArrayList(1));
        this._correctionType = (CorrectionType)capsule.readEnum("correctionType", CorrectionType.class, (Enum)CorrectionType.Perspective);
    }

    public static Image getDefaultTextureImage() {
        return _defaultTexture != null ? _defaultTexture.getImage() : null;
    }

    public static Texture getDefaultTexture() {
        if (!defaultTextureLoaded) {
            TextureState.loadDefaultTexture();
        }
        return _defaultTexture.createSimpleClone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDefaultTexture() {
        Logger logger = TextureState.logger;
        synchronized (logger) {
            if (!defaultTextureLoaded) {
                defaultTextureLoaded = true;
                _defaultTexture = new Texture2D();
                try {
                    _defaultTexture = TextureManager.load(DEFAULT_TEXTURE_SOURCE, Texture.MinificationFilter.Trilinear, true);
                }
                catch (Exception e) {
                    TextureState.logger.log(Level.WARNING, "Failed to load default texture: notloaded.tga", e);
                }
            }
        }
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new TextureStateRecord();
    }

    @Override
    public RenderState extract(Stack<? extends RenderState> stack, Spatial spat) {
        if (spat == null) {
            return stack.peek();
        }
        TextureCombineMode mode = spat.getSceneHints().getTextureCombineMode();
        if (mode == TextureCombineMode.Replace || mode != TextureCombineMode.Off && stack.size() == 1) {
            return stack.peek();
        }
        TextureState newTState = new TextureState();
        boolean foundEnabled = false;
        Object[] states = stack.toArray();
        block0 : switch (mode) {
            case CombineClosest: 
            case CombineClosestEnabled: {
                for (int iIndex = states.length - 1; iIndex >= 0; --iIndex) {
                    TextureState pkTState = (TextureState)states[iIndex];
                    if (!pkTState.isEnabled()) {
                        if (mode != TextureCombineMode.CombineClosestEnabled) continue;
                        break block0;
                    }
                    foundEnabled = true;
                    int max = pkTState.getMaxTextureIndexUsed();
                    for (int i = 0; i <= max; ++i) {
                        Texture pkText = pkTState.getTexture(i);
                        if (newTState.getTexture(i) != null) continue;
                        newTState.setTexture(pkText, i);
                    }
                }
                break;
            }
            case CombineFirst: {
                int max = states.length;
                for (int iIndex = 0; iIndex < max; ++iIndex) {
                    TextureState pkTState = (TextureState)states[iIndex];
                    if (!pkTState.isEnabled()) continue;
                    foundEnabled = true;
                    for (int i = 0; i < 32; ++i) {
                        Texture pkText = pkTState.getTexture(i);
                        if (newTState.getTexture(i) != null) continue;
                        newTState.setTexture(pkText, i);
                    }
                }
                break;
            }
        }
        newTState.setEnabled(foundEnabled);
        return newTState;
    }

    static {
        try {
            DEFAULT_TEXTURE_SOURCE = new URLResourceSource(ResourceLocatorTool.getClassPathResource(TextureState.class, "com/ardor3d/renderer/state/notloaded.tga"));
        }
        catch (Exception e) {
            DEFAULT_TEXTURE_SOURCE = null;
        }
    }

    public static enum CorrectionType {
        Affine,
        Perspective;

    }
}

