/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.renderer.state.record.VertexProgramStateRecord;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VertexProgramState
extends RenderState {
    private static final Logger logger = Logger.getLogger(VertexProgramState.class.getName());
    protected static float[][] _envparameters = new float[96][];
    protected boolean _usingParameters = false;
    protected float[][] _parameters = new float[96][];
    protected ByteBuffer _program;
    protected int _programID = -1;

    public static void setEnvParameter(float[] param, int paramID) {
        if (paramID < 0 || paramID > 95) {
            throw new IllegalArgumentException("Invalid parameter ID");
        }
        if (param != null && param.length != 4) {
            throw new IllegalArgumentException("Vertex program parameters must be of type float[4]");
        }
        VertexProgramState._envparameters[paramID] = param;
    }

    public void setParameter(float[] param, int paramID) {
        if (paramID < 0 || paramID > 95) {
            throw new IllegalArgumentException("Invalid parameter ID");
        }
        if (param != null && param.length != 4) {
            throw new IllegalArgumentException("Vertex program parameters must be of type float[4]");
        }
        this._usingParameters = true;
        this._parameters[paramID] = param;
        this.setNeedsRefresh(true);
    }

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.VertexProgram;
    }

    public void load(URL file) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(16384);
             BufferedInputStream inputStream = new BufferedInputStream(file.openStream());){
            byte[] buffer = new byte[1024];
            int byteCount = -1;
            while ((byteCount = ((InputStream)inputStream).read(buffer)) > 0) {
                outputStream.write(buffer, 0, byteCount);
            }
            byte[] data = outputStream.toByteArray();
            this._program = BufferUtils.createByteBuffer(data.length);
            this._program.put(data);
            this._program.rewind();
            this._programID = -1;
            this.setNeedsRefresh(true);
        }
        catch (Exception e) {
            logger.severe("Could not load vertex program: " + e);
            logger.logp(Level.SEVERE, this.getClass().getName(), "load(URL)", "Exception", e);
        }
    }

    public void load(String programContents) {
        try {
            byte[] bytes = programContents.getBytes();
            this._program = BufferUtils.createByteBuffer(bytes.length);
            this._program.put(bytes);
            this._program.rewind();
            this._programID = -1;
            this.setNeedsRefresh(true);
        }
        catch (Exception e) {
            logger.severe("Could not load vertex program: " + e);
            logger.logp(Level.SEVERE, this.getClass().getName(), "load(URL)", "Exception", e);
        }
    }

    public ByteBuffer getProgramAsBuffer() {
        return this._program;
    }

    public int _getProgramID() {
        return this._programID;
    }

    public void _setProgramID(int id) {
        this._programID = id;
    }

    public boolean isUsingParameters() {
        return this._usingParameters;
    }

    public float[][] _getParameters() {
        return this._parameters;
    }

    public static float[][] _getEnvParameters() {
        return _envparameters;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this._program == null) {
            s.writeInt(0);
        } else {
            s.writeInt(this._program.capacity());
            this._program.rewind();
            int len = this._program.capacity();
            for (int x = 0; x < len; ++x) {
                s.writeByte(this._program.get());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int len = s.readInt();
        if (len == 0) {
            this._program = null;
        } else {
            this._program = BufferUtils.createByteBuffer(len);
            for (int x = 0; x < len; ++x) {
                this._program.put(s.readByte());
            }
        }
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._usingParameters, "usingParameters", false);
        capsule.write(this._parameters, "parameters", (float[][])new float[96][]);
        capsule.write(this._program, "program", null);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._usingParameters = capsule.readBoolean("usingParameters", false);
        this._parameters = capsule.readFloatArray2D("parameters", (float[][])new float[96][]);
        this._program = capsule.readByteBuffer("program", null);
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new VertexProgramStateRecord();
    }
}

