/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.renderer.state.record.WireframeStateRecord;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import java.io.IOException;

public class WireframeState
extends RenderState {
    protected Face _face = Face.FrontAndBack;
    protected float _lineWidth = 1.0f;
    protected boolean _antialiased = false;

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.Wireframe;
    }

    public void setLineWidth(float width) {
        if (width < 0.0f) {
            throw new IllegalArgumentException("Line width must be positive");
        }
        this._lineWidth = width;
        this.setNeedsRefresh(true);
    }

    public float getLineWidth() {
        return this._lineWidth;
    }

    public void setFace(Face face) {
        if (face == null) {
            throw new IllegalArgumentException("face can not be null.");
        }
        this._face = face;
        this.setNeedsRefresh(true);
    }

    public Face getFace() {
        return this._face;
    }

    public void setAntialiased(boolean antialiased) {
        this._antialiased = antialiased;
        this.setNeedsRefresh(true);
    }

    public boolean isAntialiased() {
        return this._antialiased;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Enum)this._face, "face", (Enum)Face.FrontAndBack);
        capsule.write(this._lineWidth, "lineWidth", 1.0f);
        capsule.write(this._antialiased, "antialiased", false);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._face = (Face)capsule.readEnum("face", Face.class, (Enum)Face.FrontAndBack);
        this._lineWidth = capsule.readFloat("lineWidth", 1.0f);
        this._antialiased = capsule.readBoolean("antialiased", false);
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new WireframeStateRecord();
    }

    public static enum Face {
        Front,
        Back,
        FrontAndBack;

    }
}

