/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state;

import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.renderer.state.record.ZBufferStateRecord;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import java.io.IOException;

public class ZBufferState
extends RenderState {
    protected TestFunction _function = TestFunction.LessThan;
    protected boolean _writable = true;

    public TestFunction getFunction() {
        return this._function;
    }

    public void setFunction(TestFunction function) {
        if (function == null) {
            throw new IllegalArgumentException("function can not be null.");
        }
        this._function = function;
        this.setNeedsRefresh(true);
    }

    public boolean isWritable() {
        return this._writable;
    }

    public void setWritable(boolean writable) {
        this._writable = writable;
        this.setNeedsRefresh(true);
    }

    @Override
    public RenderState.StateType getType() {
        return RenderState.StateType.ZBuffer;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Enum)this._function, "function", (Enum)TestFunction.LessThan);
        capsule.write(this._writable, "writable", true);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._function = (TestFunction)capsule.readEnum("function", TestFunction.class, (Enum)TestFunction.LessThan);
        this._writable = capsule.readBoolean("writable", true);
    }

    @Override
    public StateRecord createStateRecord(ContextCapabilities caps) {
        return new ZBufferStateRecord();
    }

    public static enum TestFunction {
        Never,
        Always,
        EqualTo,
        NotEqualTo,
        LessThan,
        LessThanOrEqualTo,
        GreaterThan,
        GreaterThanOrEqualTo;

    }
}

