/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state.record;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.renderer.state.record.LightRecord;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public class LightStateRecord
extends StateRecord {
    private final List<LightRecord> lightList = new ArrayList<LightRecord>();
    private int lightMask;
    private int backLightMask;
    private boolean twoSidedOn;
    public ColorRGBA globalAmbient = new ColorRGBA(-1.0f, -1.0f, -1.0f, -1.0f);
    private boolean enabled;
    private boolean localViewer;
    private boolean separateSpecular;
    public FloatBuffer lightBuffer = BufferUtils.createColorBuffer(1);

    public int getBackLightMask() {
        return this.backLightMask;
    }

    public void setBackLightMask(int backLightMask) {
        this.backLightMask = backLightMask;
    }

    public LightRecord getLightRecord(int index) {
        if (this.lightList.size() <= index) {
            return null;
        }
        return this.lightList.get(index);
    }

    public void setLightRecord(LightRecord lr, int index) {
        while (this.lightList.size() <= index) {
            this.lightList.add(null);
        }
        this.lightList.set(index, lr);
    }

    public int getLightMask() {
        return this.lightMask;
    }

    public void setLightMask(int lightMask) {
        this.lightMask = lightMask;
    }

    public boolean isTwoSidedOn() {
        return this.twoSidedOn;
    }

    public void setTwoSidedOn(boolean twoSidedOn) {
        this.twoSidedOn = twoSidedOn;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLocalViewer() {
        return this.localViewer;
    }

    public void setLocalViewer(boolean localViewer) {
        this.localViewer = localViewer;
    }

    public boolean isSeparateSpecular() {
        return this.separateSpecular;
    }

    public void setSeparateSpecular(boolean seperateSpecular) {
        this.separateSpecular = seperateSpecular;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        for (LightRecord record : this.lightList) {
            record.invalidate();
        }
        this.lightMask = -1;
        this.backLightMask = -1;
        this.twoSidedOn = false;
        this.enabled = false;
        this.localViewer = false;
        this.separateSpecular = false;
        this.globalAmbient.set(-1.0f, -1.0f, -1.0f, -1.0f);
    }

    @Override
    public void validate() {
        super.validate();
        for (LightRecord record : this.lightList) {
            record.validate();
        }
    }
}

