/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state.record;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.renderer.state.MaterialState;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;

public class MaterialStateRecord
extends StateRecord {
    private static final Logger logger = Logger.getLogger(MaterialStateRecord.class.getName());
    public ColorRGBA frontAmbient = new ColorRGBA(-1.0f, -1.0f, -1.0f, -1.0f);
    public ColorRGBA frontDiffuse = new ColorRGBA(-1.0f, -1.0f, -1.0f, -1.0f);
    public ColorRGBA frontSpecular = new ColorRGBA(-1.0f, -1.0f, -1.0f, -1.0f);
    public ColorRGBA frontEmissive = new ColorRGBA(-1.0f, -1.0f, -1.0f, -1.0f);
    public float frontShininess = Float.NEGATIVE_INFINITY;
    public ColorRGBA backAmbient = new ColorRGBA(-1.0f, -1.0f, -1.0f, -1.0f);
    public ColorRGBA backDiffuse = new ColorRGBA(-1.0f, -1.0f, -1.0f, -1.0f);
    public ColorRGBA backSpecular = new ColorRGBA(-1.0f, -1.0f, -1.0f, -1.0f);
    public ColorRGBA backEmissive = new ColorRGBA(-1.0f, -1.0f, -1.0f, -1.0f);
    public float backShininess = Float.NEGATIVE_INFINITY;
    public MaterialState.ColorMaterial colorMaterial = null;
    public MaterialState.MaterialFace colorMaterialFace = null;
    public FloatBuffer tempColorBuff = BufferUtils.createColorBuffer(1);

    public boolean isSetColor(MaterialState.MaterialFace face, MaterialState.ColorMaterial glMatColor, ReadOnlyColorRGBA color, MaterialStateRecord record) {
        if (face == MaterialState.MaterialFace.Front) {
            switch (glMatColor) {
                case Ambient: {
                    return color.equals(this.frontAmbient);
                }
                case Diffuse: {
                    return color.equals(this.frontDiffuse);
                }
                case Specular: {
                    return color.equals(this.frontSpecular);
                }
                case Emissive: {
                    return color.equals(this.frontEmissive);
                }
            }
            logger.warning("bad isSetColor");
        } else if (face == MaterialState.MaterialFace.FrontAndBack) {
            switch (glMatColor) {
                case Ambient: {
                    return color.equals(this.frontAmbient) && color.equals(this.backAmbient);
                }
                case Diffuse: {
                    return color.equals(this.frontDiffuse) && color.equals(this.backDiffuse);
                }
                case Specular: {
                    return color.equals(this.frontSpecular) && color.equals(this.backSpecular);
                }
                case Emissive: {
                    return color.equals(this.frontEmissive) && color.equals(this.backEmissive);
                }
            }
            logger.warning("bad isSetColor");
        } else if (face == MaterialState.MaterialFace.Back) {
            switch (glMatColor) {
                case Ambient: {
                    return color.equals(this.backAmbient);
                }
                case Diffuse: {
                    return color.equals(this.backDiffuse);
                }
                case Specular: {
                    return color.equals(this.backSpecular);
                }
                case Emissive: {
                    return color.equals(this.backEmissive);
                }
            }
            logger.warning("bad isSetColor");
        }
        return false;
    }

    public boolean isSetShininess(MaterialState.MaterialFace face, float shininess, MaterialStateRecord record) {
        if (face == MaterialState.MaterialFace.Front) {
            return shininess == this.frontShininess;
        }
        if (face == MaterialState.MaterialFace.FrontAndBack) {
            return shininess == this.frontShininess && shininess == this.backShininess;
        }
        if (face == MaterialState.MaterialFace.Back) {
            return shininess == this.backShininess;
        }
        return false;
    }

    public void setColor(MaterialState.MaterialFace face, MaterialState.ColorMaterial glMatColor, ReadOnlyColorRGBA color) {
        if (face == MaterialState.MaterialFace.Front || face == MaterialState.MaterialFace.FrontAndBack) {
            switch (glMatColor) {
                case Ambient: {
                    this.frontAmbient.set(color);
                    break;
                }
                case Diffuse: {
                    this.frontDiffuse.set(color);
                    break;
                }
                case Specular: {
                    this.frontSpecular.set(color);
                    break;
                }
                case Emissive: {
                    this.frontEmissive.set(color);
                    break;
                }
                default: {
                    logger.warning("bad setColor");
                }
            }
        }
        if (face == MaterialState.MaterialFace.Back || face == MaterialState.MaterialFace.FrontAndBack) {
            switch (glMatColor) {
                case Ambient: {
                    this.backAmbient.set(color);
                    break;
                }
                case Diffuse: {
                    this.backDiffuse.set(color);
                    break;
                }
                case Specular: {
                    this.backSpecular.set(color);
                    break;
                }
                case Emissive: {
                    this.backEmissive.set(color);
                    break;
                }
                default: {
                    logger.warning("bad setColor");
                }
            }
        }
    }

    public void resetColorsForCM(MaterialState.MaterialFace face, MaterialState.ColorMaterial glMatColor) {
        if (face == MaterialState.MaterialFace.Front || face == MaterialState.MaterialFace.FrontAndBack) {
            switch (glMatColor) {
                case Ambient: {
                    this.frontAmbient.set(-1.0f, -1.0f, -1.0f, -1.0f);
                    break;
                }
                case Diffuse: {
                    this.frontDiffuse.set(-1.0f, -1.0f, -1.0f, -1.0f);
                    break;
                }
                case AmbientAndDiffuse: {
                    this.frontAmbient.set(-1.0f, -1.0f, -1.0f, -1.0f);
                    this.frontDiffuse.set(-1.0f, -1.0f, -1.0f, -1.0f);
                    break;
                }
                case Emissive: {
                    this.frontEmissive.set(-1.0f, -1.0f, -1.0f, -1.0f);
                    break;
                }
                case Specular: {
                    this.frontSpecular.set(-1.0f, -1.0f, -1.0f, -1.0f);
                }
            }
        }
        if (face == MaterialState.MaterialFace.Back || face == MaterialState.MaterialFace.FrontAndBack) {
            switch (glMatColor) {
                case Ambient: {
                    this.backAmbient.set(-1.0f, -1.0f, -1.0f, -1.0f);
                    break;
                }
                case Diffuse: {
                    this.backDiffuse.set(-1.0f, -1.0f, -1.0f, -1.0f);
                    break;
                }
                case AmbientAndDiffuse: {
                    this.backAmbient.set(-1.0f, -1.0f, -1.0f, -1.0f);
                    this.backDiffuse.set(-1.0f, -1.0f, -1.0f, -1.0f);
                    break;
                }
                case Emissive: {
                    this.backEmissive.set(-1.0f, -1.0f, -1.0f, -1.0f);
                    break;
                }
                case Specular: {
                    this.backSpecular.set(-1.0f, -1.0f, -1.0f, -1.0f);
                }
            }
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.frontAmbient.set(-1.0f, -1.0f, -1.0f, -1.0f);
        this.frontDiffuse.set(-1.0f, -1.0f, -1.0f, -1.0f);
        this.frontSpecular.set(-1.0f, -1.0f, -1.0f, -1.0f);
        this.frontEmissive.set(-1.0f, -1.0f, -1.0f, -1.0f);
        this.frontShininess = Float.NEGATIVE_INFINITY;
        this.backAmbient.set(-1.0f, -1.0f, -1.0f, -1.0f);
        this.backDiffuse.set(-1.0f, -1.0f, -1.0f, -1.0f);
        this.backSpecular.set(-1.0f, -1.0f, -1.0f, -1.0f);
        this.backEmissive.set(-1.0f, -1.0f, -1.0f, -1.0f);
        this.backShininess = Float.NEGATIVE_INFINITY;
        this.colorMaterial = null;
        this.colorMaterialFace = null;
    }
}

