/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state.record;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyRectangle2;
import com.ardor3d.renderer.DrawBufferTarget;
import com.ardor3d.renderer.state.record.StateRecord;
import java.util.Stack;

public class RendererRecord
extends StateRecord {
    private int _matrixMode = -1;
    private int _currentElementVboId = -1;
    private int _currentVboId = -1;
    private boolean _matrixValid;
    private boolean _vboValid;
    private boolean _elementVboValid;
    private boolean _clippingTestValid;
    private boolean _clippingTestEnabled;
    private final transient ColorRGBA _tempColor = new ColorRGBA();
    private DrawBufferTarget _drawBufferTarget = null;
    private final Stack<ReadOnlyRectangle2> _clips = new Stack();
    private int _normalMode = -1;
    private int _enabledTextures = 0;
    private boolean _texturesValid = false;
    private int _currentTextureArraysUnit = 0;

    @Override
    public void invalidate() {
        this.invalidateMatrix();
        this.invalidateVBO();
        this._drawBufferTarget = null;
        this._clippingTestValid = false;
        this._texturesValid = false;
        this._normalMode = -1;
        this._currentTextureArraysUnit = -1;
    }

    @Override
    public void validate() {
    }

    public void invalidateMatrix() {
        this._matrixValid = false;
        this._matrixMode = -1;
    }

    public void invalidateVBO() {
        this._vboValid = false;
        this._elementVboValid = false;
        this._currentVboId = -1;
        this._currentElementVboId = -1;
    }

    public int getMatrixMode() {
        return this._matrixMode;
    }

    public void setMatrixMode(int matrixMode) {
        this._matrixMode = matrixMode;
    }

    public int getCurrentElementVboId() {
        return this._currentElementVboId;
    }

    public void setCurrentElementVboId(int currentElementVboId) {
        this._currentElementVboId = currentElementVboId;
    }

    public int getCurrentVboId() {
        return this._currentVboId;
    }

    public void setCurrentVboId(int currentVboId) {
        this._currentVboId = currentVboId;
    }

    public boolean isMatrixValid() {
        return this._matrixValid;
    }

    public void setMatrixValid(boolean matrixValid) {
        this._matrixValid = matrixValid;
    }

    public boolean isVboValid() {
        return this._vboValid;
    }

    public void setVboValid(boolean vboValid) {
        this._vboValid = vboValid;
    }

    public boolean isElementVboValid() {
        return this._elementVboValid;
    }

    public void setElementVboValid(boolean elementVboValid) {
        this._elementVboValid = elementVboValid;
    }

    public ColorRGBA getTempColor() {
        return this._tempColor;
    }

    public DrawBufferTarget getDrawBufferTarget() {
        return this._drawBufferTarget;
    }

    public void setDrawBufferTarget(DrawBufferTarget target) {
        this._drawBufferTarget = target;
    }

    public Stack<ReadOnlyRectangle2> getScissorClips() {
        return this._clips;
    }

    public boolean isClippingTestEnabled() {
        return this._clippingTestEnabled;
    }

    public void setClippingTestEnabled(boolean enabled) {
        this._clippingTestEnabled = enabled;
    }

    public boolean isClippingTestValid() {
        return this._clippingTestValid;
    }

    public void setClippingTestValid(boolean valid) {
        this._clippingTestValid = valid;
    }

    public int getEnabledTextures() {
        return this._enabledTextures;
    }

    public void setEnabledTextures(int enabledTextures) {
        this._enabledTextures = enabledTextures;
    }

    public int getNormalMode() {
        return this._normalMode;
    }

    public void setNormalMode(int normalMode) {
        this._normalMode = normalMode;
    }

    public boolean isTexturesValid() {
        return this._texturesValid;
    }

    public void setTexturesValid(boolean texturesValid) {
        this._texturesValid = texturesValid;
    }

    public int getCurrentTextureArraysUnit() {
        return this._currentTextureArraysUnit;
    }

    public void setCurrentTextureArraysUnit(int currentTextureArraysUnit) {
        this._currentTextureArraysUnit = currentTextureArraysUnit;
    }
}

