/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer.state.record;

import com.ardor3d.image.Texture;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector4;
import com.ardor3d.renderer.state.record.StateRecord;
import com.ardor3d.renderer.state.record.TextureRecord;
import com.ardor3d.renderer.state.record.TextureUnitRecord;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Collection;
import java.util.HashMap;

public class TextureStateRecord
extends StateRecord {
    public FloatBuffer plane = BufferUtils.createFloatBuffer(4);
    public static final float[] DEFAULT_S_PLANE = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] DEFAULT_T_PLANE = new float[]{0.0f, 1.0f, 0.0f, 0.0f};
    public static final float[] DEFAULT_R_PLANE = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    public static final float[] DEFAULT_Q_PLANE = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    public HashMap<Integer, TextureRecord> textures;
    public TextureUnitRecord[] units;
    public int hint = -1;
    public int currentUnit = -1;
    public final Vector3 tmp_rotation1 = new Vector3();
    public final DoubleBuffer tmp_matrixBuffer = BufferUtils.createDoubleBuffer(16);

    public TextureStateRecord() {
        this.textures = new HashMap();
        this.units = new TextureUnitRecord[32];
        for (int i = 0; i < this.units.length; ++i) {
            this.units[i] = new TextureUnitRecord();
        }
    }

    public TextureRecord getTextureRecord(Integer textureId, Texture.Type type) {
        TextureRecord tr = this.textures.get(textureId);
        if (tr == null) {
            tr = new TextureRecord();
            this.textures.put(textureId, tr);
        }
        return tr;
    }

    public void removeTextureRecord(Integer textureId) {
        if (textureId == null) {
            return;
        }
        this.textures.remove(textureId);
        for (int i = 0; i < this.units.length; ++i) {
            if (this.units[i].boundTexture != textureId) continue;
            this.units[i].boundTexture = -1;
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.currentUnit = -1;
        this.hint = -1;
        Collection<TextureRecord> texs = this.textures.values();
        for (TextureRecord tr : texs) {
            tr.invalidate();
        }
        for (int i = 0; i < this.units.length; ++i) {
            this.units[i].invalidate();
        }
    }

    @Override
    public void validate() {
        super.validate();
        Collection<TextureRecord> texs = this.textures.values();
        for (TextureRecord tr : texs) {
            tr.validate();
        }
        for (int i = 0; i < this.units.length; ++i) {
            this.units[i].validate();
        }
    }

    public void prepPlane(ReadOnlyVector4 planeEq, float[] defaultVal) {
        if (planeEq == null) {
            this.plane.put(defaultVal);
        } else {
            this.plane.put(planeEq.getXf());
            this.plane.put(planeEq.getYf());
            this.plane.put(planeEq.getZf());
            this.plane.put(planeEq.getWf());
        }
        this.plane.rewind();
    }
}

