/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph;

import com.ardor3d.renderer.ContextCleanListener;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.RendererCallable;
import com.ardor3d.util.Constants;
import com.ardor3d.util.ContextIdReference;
import com.ardor3d.util.GameTaskQueueManager;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.nio.Buffer;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class AbstractBufferData<T extends Buffer> {
    private static Map<AbstractBufferData<?>, Object> _identityCache = new WeakHashMap();
    private static final Object STATIC_REF = new Object();
    private static ReferenceQueue<AbstractBufferData<?>> _vboRefQueue = new ReferenceQueue();
    protected transient ContextIdReference<AbstractBufferData<T>> _vboIdCache;
    protected T _buffer;
    protected VBOAccessMode _vboAccessMode = VBOAccessMode.StaticDraw;
    protected boolean _needsRefresh = false;

    AbstractBufferData() {
        _identityCache.put(this, STATIC_REF);
    }

    public abstract int getByteCount();

    public int getBufferLimit() {
        if (this._buffer != null) {
            return ((Buffer)this._buffer).limit();
        }
        return 0;
    }

    public int getBufferCapacity() {
        if (this._buffer != null) {
            return ((Buffer)this._buffer).capacity();
        }
        return 0;
    }

    public T getBuffer() {
        return this._buffer;
    }

    public void setBuffer(T buffer) {
        this._buffer = buffer;
    }

    public int getVBOID(Object glContext) {
        Integer id;
        if (this._vboIdCache != null && (id = this._vboIdCache.getValue(glContext)) != null) {
            return id;
        }
        return 0;
    }

    public int removeVBOID(Object glContext) {
        if (this._vboIdCache != null) {
            return this._vboIdCache.removeValue(glContext);
        }
        return 0;
    }

    public void setVBOID(Object glContextRep, int vboId) {
        if (vboId == 0) {
            throw new IllegalArgumentException("vboId must != 0");
        }
        if (this._vboIdCache == null) {
            this._vboIdCache = new ContextIdReference(this, _vboRefQueue);
        }
        this._vboIdCache.put(glContextRep, vboId);
    }

    public VBOAccessMode getVboAccessMode() {
        return this._vboAccessMode;
    }

    public void setVboAccessMode(VBOAccessMode vboAccessMode) {
        this._vboAccessMode = vboAccessMode;
    }

    public boolean isNeedsRefresh() {
        return this._needsRefresh;
    }

    public void setNeedsRefresh(boolean needsRefresh) {
        this._needsRefresh = needsRefresh;
    }

    public static void cleanAllVBOs(Renderer deleter) {
        ArrayListMultimap idMap = ArrayListMultimap.create();
        AbstractBufferData.gatherGCdIds((Multimap<Object, Integer>)idMap);
        for (AbstractBufferData<?> buf : _identityCache.keySet()) {
            if (buf._vboIdCache == null) continue;
            if (Constants.useMultipleContexts) {
                Set<Object> contextObjects = buf._vboIdCache.getContextObjects();
                for (Object o : contextObjects) {
                    idMap.put(o, (Object)buf.getVBOID(o));
                }
            } else {
                idMap.put(ContextManager.getCurrentContext().getGlContextRep(), (Object)buf.getVBOID(null));
            }
            buf._vboIdCache.clear();
        }
        AbstractBufferData.handleVBODelete(deleter, (Multimap<Object, Integer>)idMap);
    }

    public static void cleanAllVBOs(Renderer deleter, RenderContext context) {
        ArrayListMultimap idMap = ArrayListMultimap.create();
        AbstractBufferData.gatherGCdIds((Multimap<Object, Integer>)idMap);
        Object glRep = context.getGlContextRep();
        for (AbstractBufferData<?> buf : _identityCache.keySet()) {
            Integer id;
            if (buf._vboIdCache == null || (id = buf._vboIdCache.removeValue(glRep)) == null || id == 0) continue;
            idMap.put(context.getGlContextRep(), (Object)id);
        }
        AbstractBufferData.handleVBODelete(deleter, (Multimap<Object, Integer>)idMap);
    }

    public static void cleanExpiredVBOs(Renderer deleter) {
        Multimap<Object, Integer> idMap = AbstractBufferData.gatherGCdIds(null);
        if (idMap != null) {
            AbstractBufferData.handleVBODelete(deleter, idMap);
        }
    }

    public abstract AbstractBufferData<T> makeCopy();

    private static final Multimap<Object, Integer> gatherGCdIds(Multimap<Object, Integer> store) {
        ContextIdReference ref;
        while ((ref = (ContextIdReference)_vboRefQueue.poll()) != null) {
            if (Constants.useMultipleContexts) {
                Set<Object> contextObjects = ref.getContextObjects();
                for (Object o : contextObjects) {
                    Integer id = ref.getValue(o);
                    if (id == null) continue;
                    if (store == null) {
                        store = ArrayListMultimap.create();
                    }
                    store.put(o, (Object)id);
                }
            } else {
                Integer id = ref.getValue(null);
                if (id != null) {
                    if (store == null) {
                        store = ArrayListMultimap.create();
                    }
                    store.put(ContextManager.getCurrentContext().getGlContextRep(), (Object)id);
                }
            }
            ref.clear();
        }
        return store;
    }

    private static void handleVBODelete(Renderer deleter, final Multimap<Object, Integer> idMap) {
        Object currentGLRef = null;
        if (deleter != null && ContextManager.getCurrentContext() != null) {
            currentGLRef = ContextManager.getCurrentContext().getGlContextRep();
        }
        for (final Object glref : idMap.keySet()) {
            if (deleter != null && glref.equals(currentGLRef)) {
                deleter.deleteVBOs(idMap.get(glref));
                continue;
            }
            GameTaskQueueManager.getManager(ContextManager.getContextForRef(glref)).render(new RendererCallable<Void>(){

                @Override
                public Void call() throws Exception {
                    this.getRenderer().deleteVBOs(idMap.get(glref));
                    return null;
                }
            });
        }
    }

    public void read(InputCapsule capsule) throws IOException {
        this._vboAccessMode = (VBOAccessMode)capsule.readEnum("vboAccessMode", VBOAccessMode.class, (Enum)VBOAccessMode.StaticDraw);
    }

    public void write(OutputCapsule capsule) throws IOException {
        capsule.write((Enum)this._vboAccessMode, "vboAccessMode", (Enum)VBOAccessMode.StaticDraw);
    }

    static {
        ContextManager.addContextCleanListener(new ContextCleanListener(){

            @Override
            public void cleanForContext(RenderContext renderContext) {
                AbstractBufferData.cleanAllVBOs(null, renderContext);
            }
        });
    }

    public static enum VBOAccessMode {
        StaticDraw,
        StaticCopy,
        StaticRead,
        StreamDraw,
        StreamCopy,
        StreamRead,
        DynamicDraw,
        DynamicCopy,
        DynamicRead;

    }
}

