/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph;

import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class ByteBufferData
extends IndexBufferData<ByteBuffer>
implements Savable {
    public ByteBufferData() {
    }

    public ByteBufferData(int size) {
        this(BufferUtils.createByteBuffer(size));
    }

    public ByteBufferData(ByteBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer can not be null!");
        }
        this._buffer = buffer;
    }

    public Class<? extends ByteBufferData> getClassTag() {
        return this.getClass();
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._buffer = capsule.readByteBuffer("buffer", null);
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((ByteBuffer)this._buffer, "buffer", null);
    }

    @Override
    public int get() {
        return ((ByteBuffer)this._buffer).get() & 0xFF;
    }

    @Override
    public int get(int index) {
        return ((ByteBuffer)this._buffer).get(index) & 0xFF;
    }

    public ByteBufferData put(int value) {
        if (value < 0 || value >= 256) {
            throw new IllegalArgumentException("Invalid value passed to byte buffer: " + value);
        }
        ((ByteBuffer)this._buffer).put((byte)value);
        return this;
    }

    public ByteBufferData put(int index, int value) {
        if (value < 0 || value >= 256) {
            throw new IllegalArgumentException("Invalid value passed to byte buffer: " + value);
        }
        ((ByteBuffer)this._buffer).put(index, (byte)value);
        return this;
    }

    @Override
    public void put(IndexBufferData<?> buf) {
        if (buf instanceof ByteBufferData) {
            ((ByteBuffer)this._buffer).put((ByteBuffer)buf.getBuffer());
        } else {
            while (((Buffer)buf.getBuffer()).hasRemaining()) {
                this.put(buf.get());
            }
        }
    }

    @Override
    public void put(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            this.put(array[i]);
        }
    }

    @Override
    public void put(int[] array, int offset, int length) {
        int max = offset + length;
        for (int i = offset; i < max; ++i) {
            this.put(array[i]);
        }
    }

    @Override
    public int getByteCount() {
        return 1;
    }

    @Override
    public ByteBuffer getBuffer() {
        return (ByteBuffer)this._buffer;
    }

    @Override
    public IntBuffer asIntBuffer() {
        ByteBuffer source = this.getBuffer().duplicate();
        source.rewind();
        IntBuffer buff = BufferUtils.createIntBufferOnHeap(source.limit());
        int max = source.limit();
        for (int i = 0; i < max; ++i) {
            buff.put(source.get() & 0xFF);
        }
        buff.flip();
        return buff;
    }

    @Override
    public ByteBufferData makeCopy() {
        ByteBufferData copy = new ByteBufferData();
        copy._buffer = BufferUtils.clone((ByteBuffer)this._buffer);
        copy._vboAccessMode = this._vboAccessMode;
        return copy;
    }
}

