/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph;

import com.ardor3d.scenegraph.AbstractBufferData;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class FloatBufferData
extends AbstractBufferData<FloatBuffer>
implements Savable {
    private int _valuesPerTuple;

    public FloatBufferData() {
    }

    public FloatBufferData(int size, int valuesPerTuple) {
        this(BufferUtils.createFloatBuffer(size), valuesPerTuple);
    }

    public FloatBufferData(FloatBuffer buffer, int valuesPerTuple) {
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer can not be null!");
        }
        if (valuesPerTuple < 1) {
            throw new IllegalArgumentException("valuesPerTuple must be greater than 1.");
        }
        this._buffer = buffer;
        this._valuesPerTuple = valuesPerTuple;
    }

    @Override
    public int getByteCount() {
        return 4;
    }

    public int getTupleCount() {
        return this.getBufferLimit() / this._valuesPerTuple;
    }

    public int getValuesPerTuple() {
        return this._valuesPerTuple;
    }

    void setValuesPerTuple(int valuesPerTuple) {
        this._valuesPerTuple = valuesPerTuple;
    }

    public void scaleData(float ... scales) {
        ((FloatBuffer)this._buffer).rewind();
        for (int i = 0; i < ((FloatBuffer)this._buffer).limit(); ++i) {
            ((FloatBuffer)this._buffer).put(((FloatBuffer)this._buffer).get(i) * scales[i % scales.length]);
        }
        ((FloatBuffer)this._buffer).rewind();
    }

    public void translateData(float ... translates) {
        ((FloatBuffer)this._buffer).rewind();
        for (int i = 0; i < ((FloatBuffer)this._buffer).limit(); ++i) {
            ((FloatBuffer)this._buffer).put(((FloatBuffer)this._buffer).get(i) + translates[i % translates.length]);
        }
        ((FloatBuffer)this._buffer).rewind();
    }

    public FloatBufferData makeCopy() {
        FloatBufferData copy = new FloatBufferData();
        copy._buffer = BufferUtils.clone((FloatBuffer)this._buffer);
        copy._valuesPerTuple = this._valuesPerTuple;
        copy._vboAccessMode = this._vboAccessMode;
        return copy;
    }

    public Class<? extends FloatBufferData> getClassTag() {
        return this.getClass();
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._buffer = capsule.readFloatBuffer("buffer", null);
        this._valuesPerTuple = capsule.readInt("valuesPerTuple", 0);
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((FloatBuffer)this._buffer, "buffer", null);
        capsule.write(this._valuesPerTuple, "valuesPerTuple", 0);
    }
}

