/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph;

import com.ardor3d.math.type.ReadOnlyVector2;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.FloatBuffer;

public class FloatBufferDataUtil {
    public static FloatBufferData makeNew(ReadOnlyVector2[] coords) {
        if (coords == null) {
            return null;
        }
        return new FloatBufferData(BufferUtils.createFloatBuffer(coords), 2);
    }

    public static FloatBufferData makeNew(ReadOnlyVector3[] coords) {
        if (coords == null) {
            return null;
        }
        return new FloatBufferData(BufferUtils.createFloatBuffer(coords), 3);
    }

    public static FloatBufferData makeNew(float[] coords) {
        if (coords == null) {
            return null;
        }
        return new FloatBufferData(BufferUtils.createFloatBuffer(coords), 1);
    }

    public static FloatBufferData ensureSize(FloatBufferData tc, int vertexCount, int coordsPerVertex) {
        if (tc == null) {
            return new FloatBufferData(BufferUtils.createFloatBuffer(vertexCount * coordsPerVertex), coordsPerVertex);
        }
        if (((FloatBuffer)tc.getBuffer()).limit() == coordsPerVertex * vertexCount && tc.getValuesPerTuple() == coordsPerVertex) {
            ((FloatBuffer)tc.getBuffer()).rewind();
            return tc;
        }
        if (((FloatBuffer)tc.getBuffer()).limit() != coordsPerVertex * vertexCount) {
            return new FloatBufferData(BufferUtils.createFloatBuffer(vertexCount * coordsPerVertex), coordsPerVertex);
        }
        tc.setValuesPerTuple(coordsPerVertex);
        return tc;
    }
}

