/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph;

import com.ardor3d.math.Matrix4;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.state.GLSLShaderObjectsState;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.Ardor3dException;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public class InstancingManager {
    private int _maxBatchSize = 30;
    private final List<Mesh> _visibleMeshes = new ArrayList<Mesh>(this._maxBatchSize);
    private FloatBuffer _transformBuffer;
    private int _primCount;
    private int _meshesToDraw = 0;

    public void registerMesh(Mesh mesh) {
        this._visibleMeshes.add(mesh);
        ++this._meshesToDraw;
    }

    protected FloatBuffer fillTransformBuffer() {
        this._primCount = Math.min(this._visibleMeshes.size(), this._maxBatchSize);
        int nrOfFloats = this._primCount * 16;
        if (this._transformBuffer == null || nrOfFloats > this._transformBuffer.capacity()) {
            this._transformBuffer = BufferUtils.createFloatBuffer(nrOfFloats);
        }
        this._transformBuffer.rewind();
        this._transformBuffer.limit(nrOfFloats);
        Matrix4 mat = Matrix4.fetchTempInstance();
        for (int i = 0; i < this._maxBatchSize && this._meshesToDraw > 0; ++i) {
            Mesh mesh = this._visibleMeshes.get(--this._meshesToDraw);
            Matrix4 transform = mesh.getWorldTransform().getHomogeneousMatrix(mat);
            transform.toFloatBuffer(this._transformBuffer, false);
        }
        Matrix4.releaseTempInstance((Matrix4)mat);
        this._transformBuffer.rewind();
        return this._transformBuffer;
    }

    public int getPrimitiveCount() {
        return this._primCount;
    }

    public int getMaxBatchSize() {
        return this._maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this._maxBatchSize = maxBatchSize;
    }

    public boolean isAddedToRenderQueue() {
        return this._meshesToDraw > 0;
    }

    public boolean apply(Mesh mesh, Renderer renderer, GLSLShaderObjectsState shader) {
        RenderContext context = ContextManager.getCurrentContext();
        ContextCapabilities caps = context.getCapabilities();
        if (!caps.isGeometryInstancingSupported()) {
            throw new Ardor3dException("Geometry instancing not supported for current graphics configuration");
        }
        if (this._meshesToDraw <= 0) {
            this._primCount = -1;
            shader.setUniform("nrOfInstances", -1);
            this._visibleMeshes.clear();
            return false;
        }
        shader.setUniform("transforms", this.fillTransformBuffer(), 4);
        shader.setUniform("nrOfInstances", this.getPrimitiveCount());
        return true;
    }
}

