/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph;

import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.IntBuffer;

public class IntBufferData
extends IndexBufferData<IntBuffer>
implements Savable {
    public IntBufferData() {
    }

    public IntBufferData(int size) {
        this(BufferUtils.createIntBuffer(size));
    }

    public IntBufferData(IntBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer can not be null!");
        }
        this._buffer = buffer;
    }

    public Class<? extends IntBufferData> getClassTag() {
        return this.getClass();
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._buffer = capsule.readIntBuffer("buffer", null);
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((IntBuffer)this._buffer, "buffer", null);
    }

    @Override
    public int get() {
        return ((IntBuffer)this._buffer).get();
    }

    @Override
    public int get(int index) {
        return ((IntBuffer)this._buffer).get(index);
    }

    public IntBufferData put(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid value passed to int buffer: " + value);
        }
        ((IntBuffer)this._buffer).put(value);
        return this;
    }

    public IntBufferData put(int index, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid value passed to int buffer: " + value);
        }
        ((IntBuffer)this._buffer).put(index, value);
        return this;
    }

    @Override
    public void put(IndexBufferData<?> buf) {
        if (buf instanceof IntBufferData) {
            ((IntBuffer)this._buffer).put((IntBuffer)buf.getBuffer());
        } else {
            while (((Buffer)buf.getBuffer()).hasRemaining()) {
                this.put(buf.get());
            }
        }
    }

    @Override
    public void put(int[] array) {
        ((IntBuffer)this._buffer).put(array);
    }

    @Override
    public void put(int[] array, int offset, int length) {
        ((IntBuffer)this._buffer).put(array, offset, length);
    }

    @Override
    public int getByteCount() {
        return 4;
    }

    @Override
    public IntBuffer getBuffer() {
        return (IntBuffer)this._buffer;
    }

    @Override
    public IntBuffer asIntBuffer() {
        IntBuffer source = this.getBuffer().duplicate();
        source.rewind();
        IntBuffer buff = BufferUtils.createIntBufferOnHeap(source.limit());
        buff.put(source);
        buff.flip();
        return buff;
    }

    @Override
    public IntBufferData makeCopy() {
        IntBufferData copy = new IntBufferData();
        copy._buffer = BufferUtils.clone((IntBuffer)this._buffer);
        copy._vboAccessMode = this._vboAccessMode;
        return copy;
    }
}

