/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph;

import com.ardor3d.math.MathUtils;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector2;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.scenegraph.FloatBufferDataUtil;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;

public class Line
extends Mesh {
    private float _lineWidth = 1.0f;
    private short _stipplePattern = (short)-1;
    private int _stippleFactor = 1;
    private boolean _antialiased = false;

    public Line() {
        this("line");
    }

    public Line(String name) {
        super(name);
        this._meshData.setIndexMode(IndexMode.Lines);
    }

    public Line(String name, FloatBuffer vertex, FloatBuffer normal, FloatBuffer color, FloatBufferData coords) {
        super(name);
        this.setupData(vertex, normal, color, coords);
        this._meshData.setIndexMode(IndexMode.Lines);
    }

    public Line(String name, ReadOnlyVector3[] vertex, ReadOnlyVector3[] normal, ReadOnlyColorRGBA[] color, ReadOnlyVector2[] texture) {
        super(name);
        this.setupData(BufferUtils.createFloatBuffer(vertex), BufferUtils.createFloatBuffer(normal), BufferUtils.createFloatBuffer(color), FloatBufferDataUtil.makeNew(texture));
        this._meshData.setIndexMode(IndexMode.Lines);
    }

    private void setupData(FloatBuffer vertices, FloatBuffer normals, FloatBuffer colors, FloatBufferData coords) {
        this._meshData.setVertexBuffer(vertices);
        this._meshData.setNormalBuffer(normals);
        this._meshData.setColorBuffer(colors);
        this._meshData.setTextureCoords(coords, 0);
        this._meshData.setIndices(null);
    }

    public void appendCircle(double radius, double x, double y, int segments, boolean insideOut) {
        int requiredFloats = segments * 2 * 3;
        FloatBuffer verts = BufferUtils.ensureLargeEnough(this._meshData.getVertexBuffer(), requiredFloats);
        this._meshData.setVertexBuffer(verts);
        FloatBuffer normals = BufferUtils.ensureLargeEnough(this._meshData.getNormalBuffer(), requiredFloats);
        this._meshData.setNormalBuffer(normals);
        double angle = 0.0;
        double step = Math.PI * 2 / (double)segments;
        for (int i = 0; i < segments; ++i) {
            double dx = MathUtils.cos((double)(insideOut ? -angle : angle)) * radius;
            double dy = MathUtils.sin((double)(insideOut ? -angle : angle)) * radius;
            if (i > 0) {
                verts.put((float)(dx + x)).put((float)(dy + y)).put(0.0f);
                normals.put((float)dx).put((float)dy).put(0.0f);
            }
            verts.put((float)(dx + x)).put((float)(dy + y)).put(0.0f);
            normals.put((float)dx).put((float)dy).put(0.0f);
            angle += step;
        }
        verts.put((float)(radius + x)).put((float)y).put(0.0f);
        normals.put((float)radius).put(0.0f).put(0.0f);
    }

    public boolean isAntialiased() {
        return this._antialiased;
    }

    public void setAntialiased(boolean antialiased) {
        this._antialiased = antialiased;
    }

    public float getLineWidth() {
        return this._lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this._lineWidth = lineWidth;
    }

    public short getStipplePattern() {
        return this._stipplePattern;
    }

    public void setStipplePattern(short stipplePattern) {
        this._stipplePattern = stipplePattern;
    }

    public int getStippleFactor() {
        return this._stippleFactor;
    }

    public void setStippleFactor(int stippleFactor) {
        this._stippleFactor = stippleFactor;
    }

    @Override
    public Line makeCopy(boolean shareGeometricData) {
        Line lineCopy = (Line)super.makeCopy(shareGeometricData);
        lineCopy.setAntialiased(this._antialiased);
        lineCopy.setLineWidth(this._lineWidth);
        lineCopy.setStippleFactor(this._stippleFactor);
        lineCopy.setStipplePattern(this._stipplePattern);
        return lineCopy;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._lineWidth, "lineWidth", 1.0f);
        capsule.write(this._stipplePattern, "stipplePattern", (short)-1);
        capsule.write(this._antialiased, "antialiased", false);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._lineWidth = capsule.readFloat("lineWidth", 1.0f);
        this._stipplePattern = capsule.readShort("stipplePattern", (short)-1);
        this._antialiased = capsule.readBoolean("antialiased", false);
    }

    @Override
    public void render(Renderer renderer) {
        renderer.setupLineParameters(this.getLineWidth(), this.getStippleFactor(), this.getStipplePattern(), this.isAntialiased());
        super.render(renderer);
    }
}

