/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph;

import com.ardor3d.bounding.BoundingSphere;
import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.bounding.CollisionTree;
import com.ardor3d.bounding.CollisionTreeManager;
import com.ardor3d.intersection.IntersectionRecord;
import com.ardor3d.intersection.Pickable;
import com.ardor3d.intersection.PrimitiveKey;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Ray3;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyRay3;
import com.ardor3d.math.type.ReadOnlyTransform;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.state.GLSLShaderObjectsState;
import com.ardor3d.renderer.state.LightState;
import com.ardor3d.renderer.state.LightUtil;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.InstancingManager;
import com.ardor3d.scenegraph.MeshData;
import com.ardor3d.scenegraph.Renderable;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.event.DirtyType;
import com.ardor3d.scenegraph.hint.DataMode;
import com.ardor3d.scenegraph.hint.NormalsMode;
import com.ardor3d.util.Constants;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import com.ardor3d.util.scenegraph.RenderDelegate;
import com.ardor3d.util.stat.StatCollector;
import com.ardor3d.util.stat.StatType;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.EnumMap;

public class Mesh
extends Spatial
implements Renderable,
Pickable {
    public static boolean RENDER_VERTEX_ONLY = false;
    protected MeshData _meshData = new MeshData();
    protected BoundingVolume _modelBound = new BoundingSphere(Double.POSITIVE_INFINITY, Vector3.ZERO);
    protected final EnumMap<RenderState.StateType, RenderState> _states = new EnumMap(RenderState.StateType.class);
    protected transient LightState _lightState;
    protected ColorRGBA _defaultColor = new ColorRGBA(ColorRGBA.WHITE);
    protected boolean _isVisible = true;

    public Mesh() {
    }

    public Mesh(String name) {
        super(name);
    }

    public MeshData getMeshData() {
        return this._meshData;
    }

    public void setMeshData(MeshData meshData) {
        CollisionTreeManager.INSTANCE.removeCollisionTree(this);
        this._meshData = meshData;
    }

    public BoundingVolume getModelBound() {
        return this._modelBound;
    }

    public BoundingVolume getModelBound(BoundingVolume store) {
        if (this._modelBound == null) {
            return null;
        }
        return this._modelBound.clone(store);
    }

    public void setModelBound(BoundingVolume modelBound) {
        this.setModelBound(modelBound, true);
    }

    public void setModelBound(BoundingVolume modelBound, boolean autoCompute) {
        BoundingVolume boundingVolume = this._modelBound = modelBound != null ? modelBound.clone(this._modelBound) : null;
        if (autoCompute) {
            this.updateModelBound();
        }
        this.markDirty(DirtyType.Bounding);
    }

    public void updateModelBound() {
        if (this._modelBound != null && this._meshData.getVertexBuffer() != null) {
            this._modelBound.computeFromPoints(this._meshData.getVertexBuffer().duplicate());
            this.markDirty(DirtyType.Bounding);
        }
    }

    @Override
    public void updateWorldBound(boolean recurse) {
        this._worldBound = this._modelBound != null ? this._modelBound.transform((ReadOnlyTransform)this._worldTransform, this._worldBound) : null;
        this.clearDirty(DirtyType.Bounding);
    }

    public FloatBuffer getWorldVectors(FloatBuffer store) {
        FloatBuffer vertBuf = this._meshData.getVertexBuffer();
        if (store == null || store.capacity() != vertBuf.limit()) {
            store = BufferUtils.createFloatBuffer(vertBuf.limit());
        }
        Vector3 compVect = Vector3.fetchTempInstance();
        int vSize = store.capacity() / 3;
        for (int v = 0; v < vSize; ++v) {
            BufferUtils.populateFromBuffer(compVect, vertBuf, v);
            this._worldTransform.applyForward(compVect);
            BufferUtils.setInBuffer((ReadOnlyVector3)compVect, store, v);
        }
        Vector3.releaseTempInstance((Vector3)compVect);
        return store;
    }

    public FloatBuffer getWorldNormals(FloatBuffer store) {
        FloatBuffer normBuf = this._meshData.getNormalBuffer();
        if (store == null || store.capacity() != normBuf.limit()) {
            store = BufferUtils.createFloatBuffer(normBuf.limit());
        }
        Vector3 compVect = Vector3.fetchTempInstance();
        int vSize = store.capacity() / 3;
        for (int v = 0; v < vSize; ++v) {
            BufferUtils.populateFromBuffer(compVect, normBuf, v);
            this._worldTransform.applyForwardVector(compVect);
            BufferUtils.setInBuffer((ReadOnlyVector3)compVect, store, v);
        }
        Vector3.releaseTempInstance((Vector3)compVect);
        return store;
    }

    @Override
    public void render(Renderer renderer) {
        if (this.isVisible()) {
            this.render(renderer, this.getMeshData());
        }
    }

    public void render(Renderer renderer, MeshData meshData) {
        boolean useVBO;
        GLSLShaderObjectsState glsl = (GLSLShaderObjectsState)renderer.getProperRenderState(RenderState.StateType.GLSLShader, this._states.get((Object)RenderState.StateType.GLSLShader));
        if (glsl != null && glsl.getShaderDataLogic() != null) {
            glsl.setMesh(this);
            glsl.setNeedsRefresh(true);
        }
        InstancingManager instancing = glsl != null ? meshData.getInstancingManager() : null;
        RenderContext context = ContextManager.getCurrentContext();
        ContextCapabilities caps = context.getCapabilities();
        for (RenderState.StateType type : RenderState.StateType.values) {
            if (type == RenderState.StateType.GLSLShader || type == RenderState.StateType.FragmentProgram || type == RenderState.StateType.VertexProgram) continue;
            renderer.applyState(type, this._states.get((Object)type));
        }
        boolean bl = useVBO = (this.getSceneHints().getDataMode() == DataMode.VBO || this.getSceneHints().getDataMode() == DataMode.VBOInterleaved) && caps.isVBOSupported();
        if (instancing == null) {
            boolean transformed = renderer.doTransforms((ReadOnlyTransform)this._worldTransform);
            renderer.applyState(RenderState.StateType.GLSLShader, this._states.get((Object)RenderState.StateType.GLSLShader));
            renderer.applyState(RenderState.StateType.FragmentProgram, this._states.get((Object)RenderState.StateType.FragmentProgram));
            renderer.applyState(RenderState.StateType.VertexProgram, this._states.get((Object)RenderState.StateType.VertexProgram));
            if (useVBO) {
                this.renderVBO(renderer, meshData, -1);
            } else {
                this.renderArrays(renderer, meshData, -1, caps);
            }
            if (transformed) {
                renderer.undoTransforms((ReadOnlyTransform)this._worldTransform);
            }
        } else {
            while (instancing.apply(this, renderer, glsl)) {
                renderer.applyState(RenderState.StateType.GLSLShader, this._states.get((Object)RenderState.StateType.GLSLShader));
                renderer.applyState(RenderState.StateType.FragmentProgram, this._states.get((Object)RenderState.StateType.FragmentProgram));
                renderer.applyState(RenderState.StateType.VertexProgram, this._states.get((Object)RenderState.StateType.VertexProgram));
                if (useVBO) {
                    this.renderVBO(renderer, meshData, instancing.getPrimitiveCount());
                    continue;
                }
                this.renderArrays(renderer, meshData, instancing.getPrimitiveCount(), caps);
            }
        }
    }

    protected void renderArrays(Renderer renderer, MeshData meshData, int primcount, ContextCapabilities caps) {
        if (caps.isVBOSupported()) {
            renderer.unbindVBO();
        }
        if (RENDER_VERTEX_ONLY) {
            renderer.applyNormalsMode(NormalsMode.Off, null);
            renderer.setupNormalData(null);
            renderer.applyDefaultColor(null);
            renderer.setupColorData(null);
            renderer.setupTextureData(null);
        } else {
            renderer.applyNormalsMode(this.getSceneHints().getNormalsMode(), (ReadOnlyTransform)this._worldTransform);
            if (this.getSceneHints().getNormalsMode() != NormalsMode.Off) {
                renderer.setupNormalData(meshData.getNormalCoords());
            } else {
                renderer.setupNormalData(null);
            }
            if (meshData.getColorCoords() != null) {
                renderer.setupColorData(meshData.getColorCoords());
            } else {
                renderer.applyDefaultColor((ReadOnlyColorRGBA)this._defaultColor);
                renderer.setupColorData(null);
            }
            renderer.setupTextureData(meshData.getTextureCoords());
        }
        renderer.setupVertexData(meshData.getVertexCoords());
        if (meshData.getIndices() != null) {
            renderer.drawElements(meshData.getIndices(), meshData.getIndexLengths(), meshData.getIndexModes(), primcount);
        } else {
            renderer.drawArrays(meshData.getVertexCoords(), meshData.getIndexLengths(), meshData.getIndexModes(), primcount);
        }
        if (Constants.stats) {
            StatCollector.addStat(StatType.STAT_VERTEX_COUNT, meshData.getVertexCount());
            StatCollector.addStat(StatType.STAT_MESH_COUNT, 1.0);
        }
    }

    protected void renderVBO(Renderer renderer, MeshData meshData, int primcount) {
        if (this.getSceneHints().getDataMode() == DataMode.VBOInterleaved) {
            if (meshData.getColorCoords() == null) {
                renderer.applyDefaultColor((ReadOnlyColorRGBA)this._defaultColor);
            }
            renderer.applyNormalsMode(this.getSceneHints().getNormalsMode(), (ReadOnlyTransform)this._worldTransform);
            if (meshData.getInterleavedData() == null) {
                FloatBufferData interleaved = new FloatBufferData(FloatBuffer.allocate(0), 1);
                meshData.setInterleavedData(interleaved);
            }
            renderer.setupInterleavedDataVBO(meshData.getInterleavedData(), meshData.getVertexCoords(), meshData.getNormalCoords(), meshData.getColorCoords(), meshData.getTextureCoords());
        } else {
            if (RENDER_VERTEX_ONLY) {
                renderer.applyNormalsMode(NormalsMode.Off, null);
                renderer.setupNormalDataVBO(null);
                renderer.applyDefaultColor(null);
                renderer.setupColorDataVBO(null);
                renderer.setupTextureDataVBO(null);
            } else {
                renderer.applyNormalsMode(this.getSceneHints().getNormalsMode(), (ReadOnlyTransform)this._worldTransform);
                if (this.getSceneHints().getNormalsMode() != NormalsMode.Off) {
                    renderer.setupNormalDataVBO(meshData.getNormalCoords());
                } else {
                    renderer.setupNormalDataVBO(null);
                }
                if (meshData.getColorCoords() != null) {
                    renderer.setupColorDataVBO(meshData.getColorCoords());
                } else {
                    renderer.applyDefaultColor((ReadOnlyColorRGBA)this._defaultColor);
                    renderer.setupColorDataVBO(null);
                }
                renderer.setupTextureDataVBO(meshData.getTextureCoords());
            }
            renderer.setupVertexDataVBO(meshData.getVertexCoords());
        }
        if (meshData.getIndices() != null) {
            renderer.drawElementsVBO(meshData.getIndices(), meshData.getIndexLengths(), meshData.getIndexModes(), primcount);
        } else {
            renderer.drawArrays(meshData.getVertexCoords(), meshData.getIndexLengths(), meshData.getIndexModes(), primcount);
        }
        if (Constants.stats) {
            StatCollector.addStat(StatType.STAT_VERTEX_COUNT, meshData.getVertexCount());
            StatCollector.addStat(StatType.STAT_MESH_COUNT, 1.0);
        }
    }

    @Override
    protected void applyWorldRenderStates(boolean recurse, RenderState.StateStack stack) {
        this._states.clear();
        stack.extract(this._states, this);
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public void setVisible(boolean isVisible) {
        this._isVisible = isVisible;
    }

    @Override
    public void draw(Renderer r) {
        if (!r.isProcessingQueue() && r.checkAndAdd(this)) {
            return;
        }
        RenderDelegate delegate = this.getCurrentRenderDelegate();
        if (delegate == null) {
            r.draw(this);
        } else {
            delegate.render(this, r);
        }
    }

    @Override
    public void sortLights() {
        if (this._lightState != null && this._lightState.getLightList().size() > 8) {
            LightUtil.sort(this, this._lightState.getLightList());
        }
    }

    public LightState getLightState() {
        return this._lightState;
    }

    public void setLightState(LightState lightState) {
        this._lightState = lightState;
    }

    public void setDefaultColor(ReadOnlyColorRGBA color) {
        this._defaultColor.set(color);
    }

    public ReadOnlyColorRGBA getDefaultColor() {
        return this._defaultColor;
    }

    public RenderState getWorldRenderState(RenderState.StateType type) {
        return this._states.get((Object)type);
    }

    public void setSolidColor(ReadOnlyColorRGBA color) {
        FloatBuffer colorBuf = this._meshData.getColorBuffer();
        if (colorBuf == null) {
            colorBuf = BufferUtils.createColorBuffer(this._meshData.getVertexCount());
            this._meshData.setColorBuffer(colorBuf);
        }
        colorBuf.rewind();
        int cLength = colorBuf.remaining();
        for (int x = 0; x < cLength; x += 4) {
            colorBuf.put(color.getRed());
            colorBuf.put(color.getGreen());
            colorBuf.put(color.getBlue());
            colorBuf.put(color.getAlpha());
        }
        colorBuf.flip();
    }

    public void setRandomColors() {
        FloatBuffer colorBuf = this._meshData.getColorBuffer();
        if (colorBuf == null) {
            colorBuf = BufferUtils.createColorBuffer(this._meshData.getVertexCount());
            this._meshData.setColorBuffer(colorBuf);
        } else {
            colorBuf.rewind();
        }
        int cLength = colorBuf.limit();
        for (int x = 0; x < cLength; x += 4) {
            colorBuf.put(MathUtils.nextRandomFloat());
            colorBuf.put(MathUtils.nextRandomFloat());
            colorBuf.put(MathUtils.nextRandomFloat());
            colorBuf.put(1.0f);
        }
        colorBuf.flip();
    }

    @Override
    public boolean supportsBoundsIntersectionRecord() {
        return true;
    }

    @Override
    public boolean supportsPrimitivesIntersectionRecord() {
        return true;
    }

    @Override
    public boolean intersectsWorldBound(Ray3 ray) {
        return this.getWorldBound().intersects((ReadOnlyRay3)ray);
    }

    @Override
    public IntersectionRecord intersectsWorldBoundsWhere(Ray3 ray) {
        return this.getWorldBound().intersectsWhere((ReadOnlyRay3)ray);
    }

    @Override
    public IntersectionRecord intersectsPrimitivesWhere(Ray3 ray) {
        ArrayList<PrimitiveKey> primitives = new ArrayList<PrimitiveKey>();
        CollisionTree ct = CollisionTreeManager.getInstance().getCollisionTree(this);
        if (ct != null) {
            ct.getBounds().transform(this.getWorldTransform(), ct.getWorldBounds());
            ct.intersect(ray, primitives);
        }
        if (primitives.isEmpty()) {
            return null;
        }
        Vector3[] vertices = null;
        double[] distances = new double[primitives.size()];
        for (int i = 0; i < primitives.size(); ++i) {
            double triDistanceSq;
            PrimitiveKey key = (PrimitiveKey)primitives.get(i);
            vertices = this.getMeshData().getPrimitiveVertices(key.getPrimitiveIndex(), key.getSection(), vertices);
            int max = this.getMeshData().getIndexMode(key.getSection()).getVertexCount();
            for (int j = 0; j < max; ++j) {
                if (vertices[j] == null) continue;
                this.getWorldTransform().applyForward(vertices[j]);
            }
            distances[i] = triDistanceSq = ray.getDistanceToPrimitive(vertices);
        }
        boolean sorted = false;
        while (!sorted) {
            sorted = true;
            for (int sort = 0; sort < distances.length - 1; ++sort) {
                if (!(distances[sort] > distances[sort + 1])) continue;
                sorted = false;
                double temp = distances[sort + 1];
                distances[sort + 1] = distances[sort];
                distances[sort] = temp;
                PrimitiveKey temp2 = (PrimitiveKey)primitives.get(sort + 1);
                primitives.set(sort + 1, (PrimitiveKey)primitives.get(sort));
                primitives.set(sort, temp2);
            }
        }
        Vector3[] positions = new Vector3[distances.length];
        for (int i = 0; i < distances.length; ++i) {
            positions[i] = ray.getDirection().multiply(distances[i], new Vector3()).addLocal(ray.getOrigin());
        }
        return new IntersectionRecord(distances, positions, primitives);
    }

    @Override
    public Mesh makeCopy(boolean shareGeometricData) {
        Mesh mesh = (Mesh)super.makeCopy(shareGeometricData);
        if (shareGeometricData) {
            mesh.setMeshData(this._meshData);
        } else {
            mesh.setMeshData(this._meshData.makeCopy());
        }
        mesh.setModelBound(this._modelBound != null ? this._modelBound.clone(null) : null);
        mesh.setDefaultColor((ReadOnlyColorRGBA)this._defaultColor);
        mesh.setVisible(this._isVisible);
        return mesh;
    }

    @Override
    public Mesh makeInstanced() {
        Mesh mesh = (Mesh)super.makeInstanced();
        if (this._meshData.getInstancingManager() == null) {
            this._meshData.setInstancingManager(new InstancingManager());
        }
        mesh.setMeshData(this._meshData);
        mesh.setModelBound(this._modelBound != null ? this._modelBound.clone(null) : null);
        mesh._defaultColor = this._defaultColor;
        mesh.setVisible(this._isVisible);
        return mesh;
    }

    public void reorderIndices(IndexBufferData<?> newIndices, IndexMode[] modes, int[] lengths) {
        this._meshData.setIndices(newIndices);
        this._meshData.setIndexModes(modes);
        this._meshData.setIndexLengths(lengths);
    }

    public void reorderVertexData(int[] newVertexOrder) {
        this.reorderVertexData(newVertexOrder, this._meshData);
    }

    protected void reorderVertexData(int[] newVertexOrder, MeshData meshData) {
        FloatBufferData verts = meshData.getVertexCoords().makeCopy();
        FloatBufferData norms = meshData.getNormalBuffer() != null ? meshData.getVertexCoords().makeCopy() : null;
        FloatBufferData colors = meshData.getColorBuffer() != null ? meshData.getColorCoords().makeCopy() : null;
        FloatBufferData fogs = meshData.getFogBuffer() != null ? meshData.getFogCoords().makeCopy() : null;
        FloatBufferData tangents = meshData.getTangentBuffer() != null ? meshData.getTangentCoords().makeCopy() : null;
        FloatBufferData[] uvs = new FloatBufferData[meshData.getNumberOfUnits()];
        for (int k = 0; k < uvs.length; ++k) {
            FloatBufferData tex = meshData.getTextureCoords(k);
            if (tex == null) continue;
            uvs[k] = tex.makeCopy();
        }
        for (int i = 0; i < meshData.getVertexCount(); ++i) {
            int vert = newVertexOrder[i];
            if (vert == -1) {
                vert = i;
            }
            BufferUtils.copy(meshData.getVertexBuffer(), i * verts.getValuesPerTuple(), (FloatBuffer)verts.getBuffer(), vert * verts.getValuesPerTuple(), verts.getValuesPerTuple());
            if (norms != null) {
                BufferUtils.copy(meshData.getNormalBuffer(), i * norms.getValuesPerTuple(), (FloatBuffer)norms.getBuffer(), vert * norms.getValuesPerTuple(), norms.getValuesPerTuple());
            }
            if (colors != null) {
                BufferUtils.copy(meshData.getColorBuffer(), i * colors.getValuesPerTuple(), (FloatBuffer)colors.getBuffer(), vert * colors.getValuesPerTuple(), colors.getValuesPerTuple());
            }
            if (fogs != null) {
                BufferUtils.copy(meshData.getFogBuffer(), i * fogs.getValuesPerTuple(), (FloatBuffer)fogs.getBuffer(), vert * fogs.getValuesPerTuple(), fogs.getValuesPerTuple());
            }
            if (tangents != null) {
                BufferUtils.copy(meshData.getTangentBuffer(), i * tangents.getValuesPerTuple(), (FloatBuffer)tangents.getBuffer(), vert * tangents.getValuesPerTuple(), tangents.getValuesPerTuple());
            }
            for (int k = 0; k < uvs.length; ++k) {
                if (uvs[k] == null) continue;
                BufferUtils.copy(meshData.getTextureBuffer(k), i * uvs[k].getValuesPerTuple(), (FloatBuffer)uvs[k].getBuffer(), vert * uvs[k].getValuesPerTuple(), uvs[k].getValuesPerTuple());
            }
        }
        meshData.setVertexCoords(verts);
        meshData.setNormalCoords(norms);
        meshData.setColorCoords(colors);
        meshData.setFogCoords(fogs);
        meshData.setTangentCoords(tangents);
        for (int k = 0; k < uvs.length; ++k) {
            if (uvs[k] == null) continue;
            meshData.setTextureCoords(uvs[k], k);
        }
    }

    public Class<? extends Mesh> getClassTag() {
        return this.getClass();
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Savable)this._meshData, "meshData", null);
        capsule.write((Savable)this._modelBound, "modelBound", null);
        capsule.write((Savable)this._defaultColor, "defaultColor", (Savable)new ColorRGBA(ColorRGBA.WHITE));
        capsule.write(this._isVisible, "visible", true);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._meshData = (MeshData)capsule.readSavable("meshData", null);
        this._modelBound = (BoundingVolume)capsule.readSavable("modelBound", null);
        this._defaultColor = (ColorRGBA)capsule.readSavable("defaultColor", (Savable)new ColorRGBA(ColorRGBA.WHITE));
        this._isVisible = capsule.readBoolean("visible", true);
    }
}

