/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph;

import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Quaternion;
import com.ardor3d.math.Transform;
import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.scenegraph.ByteBufferData;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.scenegraph.InstancingManager;
import com.ardor3d.scenegraph.IntBufferData;
import com.ardor3d.scenegraph.ShortBufferData;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public class MeshData
implements Savable {
    private static final Logger logger = Logger.getLogger(MeshData.class.getName());
    private transient Map<Object, Integer> _vboIdCache = null;
    protected int _vertexCount;
    protected transient int[] _primitiveCounts = new int[1];
    protected FloatBufferData _vertexCoords;
    protected FloatBufferData _normalCoords;
    protected FloatBufferData _colorCoords;
    protected FloatBufferData _fogCoords;
    protected FloatBufferData _tangentCoords;
    protected List<FloatBufferData> _textureCoords = new ArrayList<FloatBufferData>(1);
    protected FloatBufferData _interleaved;
    protected IndexBufferData<?> _indexBuffer;
    protected int[] _indexLengths;
    protected IndexMode[] _indexModes = new IndexMode[]{IndexMode.Triangles};
    private InstancingManager _instancingManager;

    public int getVertexCount() {
        return this._vertexCount;
    }

    public FloatBuffer getVertexBuffer() {
        if (this._vertexCoords == null) {
            return null;
        }
        return (FloatBuffer)this._vertexCoords.getBuffer();
    }

    public void setVertexBuffer(FloatBuffer vertexBuffer) {
        if (vertexBuffer == null) {
            this.setVertexCoords(null);
        } else {
            this.setVertexCoords(new FloatBufferData(vertexBuffer, 3));
        }
        this.refreshInterleaved();
    }

    public FloatBufferData getVertexCoords() {
        return this._vertexCoords;
    }

    private void refreshInterleaved() {
        if (this._interleaved != null) {
            this._interleaved.setNeedsRefresh(true);
        }
    }

    public void setVertexCoords(FloatBufferData bufferData) {
        this._vertexCoords = bufferData;
        this.updateVertexCount();
        this.refreshInterleaved();
    }

    public FloatBuffer getNormalBuffer() {
        if (this._normalCoords == null) {
            return null;
        }
        return (FloatBuffer)this._normalCoords.getBuffer();
    }

    public void setNormalBuffer(FloatBuffer normalBuffer) {
        this._normalCoords = normalBuffer == null ? null : new FloatBufferData(normalBuffer, 3);
        this.refreshInterleaved();
    }

    public FloatBufferData getNormalCoords() {
        return this._normalCoords;
    }

    public void setNormalCoords(FloatBufferData bufferData) {
        this._normalCoords = bufferData;
        this.refreshInterleaved();
    }

    public FloatBuffer getColorBuffer() {
        if (this._colorCoords == null) {
            return null;
        }
        return (FloatBuffer)this._colorCoords.getBuffer();
    }

    public void setColorBuffer(FloatBuffer colorBuffer) {
        this._colorCoords = colorBuffer == null ? null : new FloatBufferData(colorBuffer, 4);
        this.refreshInterleaved();
    }

    public FloatBufferData getColorCoords() {
        return this._colorCoords;
    }

    public void setColorCoords(FloatBufferData bufferData) {
        this._colorCoords = bufferData;
        this.refreshInterleaved();
    }

    public FloatBuffer getFogBuffer() {
        if (this._fogCoords == null) {
            return null;
        }
        return (FloatBuffer)this._fogCoords.getBuffer();
    }

    public void setFogBuffer(FloatBuffer fogBuffer) {
        this._fogCoords = fogBuffer == null ? null : new FloatBufferData(fogBuffer, 3);
    }

    public FloatBufferData getFogCoords() {
        return this._fogCoords;
    }

    public void setFogCoords(FloatBufferData bufferData) {
        this._fogCoords = bufferData;
    }

    public FloatBuffer getTangentBuffer() {
        if (this._tangentCoords == null) {
            return null;
        }
        return (FloatBuffer)this._tangentCoords.getBuffer();
    }

    public void setTangentBuffer(FloatBuffer tangentBuffer) {
        this._tangentCoords = tangentBuffer == null ? null : new FloatBufferData(tangentBuffer, 3);
    }

    public FloatBufferData getTangentCoords() {
        return this._tangentCoords;
    }

    public void setTangentCoords(FloatBufferData bufferData) {
        this._tangentCoords = bufferData;
    }

    public FloatBuffer getTextureBuffer(int index) {
        if (this._textureCoords.size() <= index) {
            return null;
        }
        FloatBufferData textureCoord = this._textureCoords.get(index);
        if (textureCoord == null) {
            return null;
        }
        return (FloatBuffer)textureCoord.getBuffer();
    }

    public void setTextureBuffer(FloatBuffer textureBuffer, int index) {
        if (textureBuffer != null) {
            while (this._textureCoords.size() <= index) {
                this._textureCoords.add(null);
            }
            this._textureCoords.set(index, new FloatBufferData(textureBuffer, 2));
        } else if (index < this._textureCoords.size()) {
            this._textureCoords.set(index, null);
        }
        this.refreshInterleaved();
    }

    public List<FloatBufferData> getTextureCoords() {
        return this._textureCoords;
    }

    public FloatBufferData getTextureCoords(int index) {
        if (this._textureCoords.size() <= index) {
            return null;
        }
        return this._textureCoords.get(index);
    }

    public void setTextureCoords(List<FloatBufferData> textureCoords) {
        this._textureCoords = textureCoords;
        this.refreshInterleaved();
    }

    public void setTextureCoords(FloatBufferData textureCoords, int index) {
        while (this._textureCoords.size() <= index) {
            this._textureCoords.add(null);
        }
        this._textureCoords.set(index, textureCoords);
        this.refreshInterleaved();
    }

    public FloatBuffer getInterleavedBuffer() {
        if (this._interleaved == null) {
            return null;
        }
        return (FloatBuffer)this._interleaved.getBuffer();
    }

    public FloatBufferData getInterleavedData() {
        return this._interleaved;
    }

    public void setInterleavedData(FloatBufferData interleavedData) {
        this._interleaved = interleavedData;
        this.refreshInterleaved();
    }

    public void updateVertexCount() {
        this._vertexCount = this._vertexCoords == null ? 0 : this._vertexCoords.getTupleCount();
        if (this._indexBuffer == null) {
            this.updatePrimitiveCounts();
        }
    }

    public void copyTextureCoordinates(int fromIndex, int toIndex, float factor) {
        if (this._textureCoords == null) {
            return;
        }
        if (fromIndex < 0 || fromIndex >= this._textureCoords.size() || this._textureCoords.get(fromIndex) == null) {
            return;
        }
        if (toIndex < 0 || toIndex == fromIndex) {
            return;
        }
        while (toIndex >= this._textureCoords.size()) {
            this._textureCoords.add(null);
        }
        FloatBufferData dest = this._textureCoords.get(toIndex);
        FloatBufferData src = this._textureCoords.get(fromIndex);
        if (dest == null || ((FloatBuffer)dest.getBuffer()).capacity() != ((FloatBuffer)src.getBuffer()).limit()) {
            dest = new FloatBufferData(BufferUtils.createFloatBuffer(((FloatBuffer)src.getBuffer()).capacity()), src.getValuesPerTuple());
            this._textureCoords.set(toIndex, dest);
        }
        ((FloatBuffer)dest.getBuffer()).clear();
        int oldLimit = ((FloatBuffer)src.getBuffer()).limit();
        ((FloatBuffer)src.getBuffer()).clear();
        int len = ((FloatBuffer)dest.getBuffer()).capacity();
        for (int i = 0; i < len; ++i) {
            ((FloatBuffer)dest.getBuffer()).put(factor * ((FloatBuffer)src.getBuffer()).get());
        }
        ((FloatBuffer)src.getBuffer()).limit(oldLimit);
        ((FloatBuffer)dest.getBuffer()).limit(oldLimit);
    }

    public void copyTextureCoordinates(int fromIndex, int toIndex, float factorS, float factorT) {
        if (this._textureCoords == null) {
            return;
        }
        if (fromIndex < 0 || fromIndex >= this._textureCoords.size() || this._textureCoords.get(fromIndex) == null) {
            return;
        }
        if (toIndex < 0 || toIndex == fromIndex) {
            return;
        }
        while (toIndex >= this._textureCoords.size()) {
            this._textureCoords.add(null);
        }
        FloatBufferData dest = this._textureCoords.get(toIndex);
        FloatBufferData src = this._textureCoords.get(fromIndex);
        if (dest == null || ((FloatBuffer)dest.getBuffer()).capacity() != ((FloatBuffer)src.getBuffer()).limit()) {
            dest = new FloatBufferData(BufferUtils.createFloatBuffer(((FloatBuffer)src.getBuffer()).capacity()), src.getValuesPerTuple());
            this._textureCoords.set(toIndex, dest);
        }
        ((FloatBuffer)dest.getBuffer()).clear();
        int oldLimit = ((FloatBuffer)src.getBuffer()).limit();
        ((FloatBuffer)src.getBuffer()).clear();
        int len = ((FloatBuffer)dest.getBuffer()).capacity();
        for (int i = 0; i < len; ++i) {
            if (i % 2 == 0) {
                ((FloatBuffer)dest.getBuffer()).put(factorS * ((FloatBuffer)src.getBuffer()).get());
                continue;
            }
            ((FloatBuffer)dest.getBuffer()).put(factorT * ((FloatBuffer)src.getBuffer()).get());
        }
        ((FloatBuffer)src.getBuffer()).limit(oldLimit);
        ((FloatBuffer)dest.getBuffer()).limit(oldLimit);
    }

    public int getNumberOfUnits() {
        if (this._textureCoords == null) {
            return 0;
        }
        return this._textureCoords.size();
    }

    public Buffer getIndexBuffer() {
        if (this._indexBuffer == null) {
            return null;
        }
        return this._indexBuffer.getBuffer();
    }

    public void setIndexBuffer(IntBuffer indices) {
        this._indexBuffer = indices == null ? null : new IntBufferData(indices);
        this.updatePrimitiveCounts();
        this.refreshInterleaved();
    }

    public void setIndexBuffer(ShortBuffer indices) {
        this._indexBuffer = indices == null ? null : new ShortBufferData(indices);
        this.updatePrimitiveCounts();
        this.refreshInterleaved();
    }

    public void setIndexBuffer(ByteBuffer indices) {
        this._indexBuffer = indices == null ? null : new ByteBufferData(indices);
        this.updatePrimitiveCounts();
        this.refreshInterleaved();
    }

    public IndexBufferData<?> getIndices() {
        return this._indexBuffer;
    }

    public void setIndices(IndexBufferData<?> bufferData) {
        this._indexBuffer = bufferData;
        this.updatePrimitiveCounts();
        this.refreshInterleaved();
    }

    @Deprecated
    public IndexMode getIndexMode() {
        return this.getIndexMode(0);
    }

    public void setIndexMode(IndexMode indexMode) {
        this._indexModes[0] = indexMode;
        this.updatePrimitiveCounts();
        this.refreshInterleaved();
    }

    public int[] getIndexLengths() {
        return this._indexLengths;
    }

    public void setIndexLengths(int[] indexLengths) {
        this._indexLengths = indexLengths;
        this.updatePrimitiveCounts();
        this.refreshInterleaved();
    }

    public IndexMode[] getIndexModes() {
        return this._indexModes;
    }

    public IndexMode getIndexMode(int sectionIndex) {
        if (sectionIndex < 0 || sectionIndex >= this.getSectionCount()) {
            throw new IllegalArgumentException("invalid section index: " + sectionIndex);
        }
        return this._indexModes.length > sectionIndex ? this._indexModes[sectionIndex] : this._indexModes[this._indexModes.length - 1];
    }

    public void setIndexModes(IndexMode[] indexModes) {
        this._indexModes = indexModes;
        this.updatePrimitiveCounts();
        this.refreshInterleaved();
    }

    public int getSectionCount() {
        return this._indexLengths != null ? this._indexLengths.length : 1;
    }

    public int getTotalPrimitiveCount() {
        int count = 0;
        for (int i = 0; i < this._primitiveCounts.length; ++i) {
            count += this._primitiveCounts[i];
        }
        return count;
    }

    public int getPrimitiveCount(int section) {
        return this._primitiveCounts[section];
    }

    public int[] getPrimitiveIndices(int primitiveIndex, int section, int[] store) {
        int count = this.getPrimitiveCount(section);
        if (primitiveIndex >= count || primitiveIndex < 0) {
            throw new IndexOutOfBoundsException("Invalid primitiveIndex '" + primitiveIndex + "'.  Count is " + count);
        }
        IndexMode mode = this.getIndexMode(section);
        int rSize = mode.getVertexCount();
        int[] result = store;
        if (result == null || result.length < rSize) {
            result = new int[rSize];
        }
        for (int i = 0; i < rSize; ++i) {
            result[i] = this.getIndices() != null ? this.getIndices().get(this.getVertexIndex(primitiveIndex, i, section)) : this.getVertexIndex(primitiveIndex, i, section);
        }
        return result;
    }

    public Vector3[] getPrimitiveVertices(int primitiveIndex, int section, Vector3[] store) {
        int count = this.getPrimitiveCount(section);
        if (primitiveIndex >= count || primitiveIndex < 0) {
            throw new IndexOutOfBoundsException("Invalid primitiveIndex '" + primitiveIndex + "'.  Count is " + count);
        }
        IndexMode mode = this.getIndexMode(section);
        int rSize = mode.getVertexCount();
        Vector3[] result = store;
        if (result == null || result.length < rSize) {
            result = new Vector3[rSize];
        }
        for (int i = 0; i < rSize; ++i) {
            if (result[i] == null) {
                result[i] = new Vector3();
            }
            if (this.getIndices() != null) {
                BufferUtils.populateFromBuffer(result[i], this.getVertexBuffer(), this.getIndices().get(this.getVertexIndex(primitiveIndex, i, section)));
                continue;
            }
            BufferUtils.populateFromBuffer(result[i], this.getVertexBuffer(), this.getVertexIndex(primitiveIndex, i, section));
        }
        return result;
    }

    public Vector2[] getPrimitiveTextureCoords(int primitiveIndex, int section, int textureIndex, Vector2[] store) {
        Vector2[] result = null;
        if (this.getTextureBuffer(textureIndex) != null) {
            int count = this.getPrimitiveCount(section);
            if (primitiveIndex >= count || primitiveIndex < 0) {
                throw new IndexOutOfBoundsException("Invalid primitiveIndex '" + primitiveIndex + "'.  Count is " + count);
            }
            IndexMode mode = this.getIndexMode(section);
            int rSize = mode.getVertexCount();
            result = store;
            if (result == null || result.length < rSize) {
                result = new Vector2[rSize];
            }
            for (int i = 0; i < rSize; ++i) {
                if (result[i] == null) {
                    result[i] = new Vector2();
                }
                if (this.getIndexBuffer() != null) {
                    BufferUtils.populateFromBuffer(result[i], this.getTextureBuffer(textureIndex), this.getIndices().get(this.getVertexIndex(primitiveIndex, i, section)));
                    continue;
                }
                BufferUtils.populateFromBuffer(result[i], this.getTextureBuffer(textureIndex), this.getVertexIndex(primitiveIndex, i, section));
            }
        }
        return result;
    }

    public int getVertexIndex(int primitiveIndex, int point, int section) {
        int index = 0;
        for (int i = 0; i < section; ++i) {
            index += this._indexLengths[i];
        }
        switch (this.getIndexMode(section)) {
            case Triangles: {
                index += primitiveIndex * 3 + point;
                break;
            }
            case TriangleStrip: {
                if (point < 2 && primitiveIndex % 2 == 1) {
                    index += primitiveIndex + (point == 0 ? 1 : 0);
                    break;
                }
                index += primitiveIndex + point;
                break;
            }
            case TriangleFan: {
                if (point == 0) {
                    index += 0;
                    break;
                }
                index += primitiveIndex + point;
                break;
            }
            case Quads: {
                index += primitiveIndex * 4 + point;
                break;
            }
            case QuadStrip: {
                index += primitiveIndex * 2 + point;
                break;
            }
            case Points: {
                index += primitiveIndex;
                break;
            }
            case Lines: {
                index += primitiveIndex * 2 + point;
                break;
            }
            case LineStrip: 
            case LineLoop: {
                index += primitiveIndex + point;
                break;
            }
            default: {
                logger.warning("unimplemented index mode: " + (Object)((Object)this.getIndexMode(0)));
                return -1;
            }
        }
        return index;
    }

    public Vector3 randomVertex(Vector3 store) {
        if (this._vertexCoords == null) {
            return null;
        }
        Vector3 result = store;
        if (result == null) {
            result = new Vector3();
        }
        int i = MathUtils.nextRandomInt((int)0, (int)(this.getVertexCount() - 1));
        BufferUtils.populateFromBuffer(result, (FloatBuffer)this._vertexCoords.getBuffer(), i);
        return result;
    }

    public Vector3 randomPointOnPrimitives(Vector3 store) {
        if (this._vertexCoords == null || this._indexBuffer == null) {
            return null;
        }
        Vector3 result = store;
        if (result == null) {
            result = new Vector3();
        }
        int section = MathUtils.nextRandomInt((int)0, (int)(this.getSectionCount() - 1));
        int primitiveIndex = MathUtils.nextRandomInt((int)0, (int)(this.getPrimitiveCount(section) - 1));
        IndexMode mode = this.getIndexMode(section);
        boolean hasIndices = this.getIndices() != null;
        switch (mode) {
            case Triangles: 
            case TriangleStrip: 
            case TriangleFan: 
            case Quads: 
            case QuadStrip: {
                int pntA = this.getVertexIndex(primitiveIndex, 0, section);
                int pntB = this.getVertexIndex(primitiveIndex, 1, section);
                int pntC = this.getVertexIndex(primitiveIndex, 2, section);
                if (hasIndices) {
                    pntA = this.getIndices().get(pntA);
                    pntB = this.getIndices().get(pntB);
                    pntC = this.getIndices().get(pntC);
                }
                double b = MathUtils.nextRandomDouble();
                double c = MathUtils.nextRandomDouble();
                if (mode != IndexMode.Quads && mode != IndexMode.QuadStrip && b + c > 1.0) {
                    b = 1.0 - b;
                    c = 1.0 - c;
                }
                double a = 1.0 - b - c;
                Vector3 work = Vector3.fetchTempInstance();
                BufferUtils.populateFromBuffer(work, this.getVertexBuffer(), pntA);
                work.multiplyLocal(a);
                result.set((ReadOnlyVector3)work);
                BufferUtils.populateFromBuffer(work, this.getVertexBuffer(), pntB);
                work.multiplyLocal(b);
                result.addLocal((ReadOnlyVector3)work);
                BufferUtils.populateFromBuffer(work, this.getVertexBuffer(), pntC);
                work.multiplyLocal(c);
                result.addLocal((ReadOnlyVector3)work);
                Vector3.releaseTempInstance((Vector3)work);
                break;
            }
            case Points: {
                int pnt = this.getVertexIndex(primitiveIndex, 0, section);
                if (hasIndices) {
                    pnt = this.getIndices().get(pnt);
                }
                BufferUtils.populateFromBuffer(result, this.getVertexBuffer(), pnt);
                break;
            }
            case Lines: 
            case LineStrip: 
            case LineLoop: {
                int pntA = this.getVertexIndex(primitiveIndex, 0, section);
                int pntB = this.getVertexIndex(primitiveIndex, 1, section);
                if (hasIndices) {
                    pntA = this.getIndices().get(pntA);
                    pntB = this.getIndices().get(pntB);
                }
                Vector3 work = Vector3.fetchTempInstance();
                BufferUtils.populateFromBuffer(result, this.getVertexBuffer(), pntA);
                BufferUtils.populateFromBuffer(work, this.getVertexBuffer(), pntB);
                Vector3.lerp((ReadOnlyVector3)result, (ReadOnlyVector3)work, (double)MathUtils.nextRandomDouble(), (Vector3)result);
                Vector3.releaseTempInstance((Vector3)work);
                break;
            }
        }
        return result;
    }

    public void translatePoints(double x, double y, double z) {
        this.translatePoints(new Vector3(x, y, z));
    }

    public void translatePoints(Vector3 amount) {
        for (int x = 0; x < this._vertexCount; ++x) {
            BufferUtils.addInBuffer((ReadOnlyVector3)amount, (FloatBuffer)this._vertexCoords.getBuffer(), x);
        }
    }

    public void transformVertices(Transform transform) {
        Vector3 store = new Vector3();
        for (int x = 0; x < this._vertexCount; ++x) {
            BufferUtils.populateFromBuffer(store, (FloatBuffer)this._vertexCoords.getBuffer(), x);
            transform.applyForward((ReadOnlyVector3)store, store);
            BufferUtils.setInBuffer((ReadOnlyVector3)store, (FloatBuffer)this._vertexCoords.getBuffer(), x);
        }
    }

    public void transformNormals(Transform transform, boolean normalize) {
        Vector3 store = new Vector3();
        for (int x = 0; x < this._vertexCount; ++x) {
            BufferUtils.populateFromBuffer(store, (FloatBuffer)this._normalCoords.getBuffer(), x);
            transform.applyForwardVector((ReadOnlyVector3)store, store);
            if (normalize) {
                store.normalizeLocal();
            }
            BufferUtils.setInBuffer((ReadOnlyVector3)store, (FloatBuffer)this._normalCoords.getBuffer(), x);
        }
    }

    public void rotatePoints(Quaternion rotate) {
        Vector3 store = new Vector3();
        for (int x = 0; x < this._vertexCount; ++x) {
            BufferUtils.populateFromBuffer(store, (FloatBuffer)this._vertexCoords.getBuffer(), x);
            rotate.apply((ReadOnlyVector3)store, store);
            BufferUtils.setInBuffer((ReadOnlyVector3)store, (FloatBuffer)this._vertexCoords.getBuffer(), x);
        }
    }

    public void rotateNormals(Quaternion rotate) {
        Vector3 store = new Vector3();
        for (int x = 0; x < this._vertexCount; ++x) {
            BufferUtils.populateFromBuffer(store, (FloatBuffer)this._normalCoords.getBuffer(), x);
            rotate.apply((ReadOnlyVector3)store, store);
            BufferUtils.setInBuffer((ReadOnlyVector3)store, (FloatBuffer)this._normalCoords.getBuffer(), x);
        }
    }

    private void updatePrimitiveCounts() {
        int maxSection;
        int maxIndex = this._indexBuffer != null ? this._indexBuffer.getBufferLimit() : this._vertexCount;
        int n = maxSection = this._indexLengths != null ? this._indexLengths.length : 1;
        if (this._primitiveCounts.length != maxSection) {
            this._primitiveCounts = new int[maxSection];
        }
        for (int i = 0; i < maxSection; ++i) {
            int count;
            int size = this._indexLengths != null ? this._indexLengths[i] : maxIndex;
            this._primitiveCounts[i] = count = IndexMode.getPrimitiveCount(this.getIndexMode(i), size);
        }
    }

    public int getVBOInterleavedID(Object glContext) {
        if (this._vboIdCache != null && this._vboIdCache.containsKey(glContext)) {
            return this._vboIdCache.get(glContext);
        }
        return 0;
    }

    public void setVBOInterleavedID(Object glContext, int vboId) {
        if (vboId == 0) {
            throw new IllegalArgumentException("vboId must != 0");
        }
        if (this._vboIdCache == null) {
            this._vboIdCache = new WeakHashMap<Object, Integer>(1);
        }
        this._vboIdCache.put(glContext, vboId);
    }

    public MeshData makeCopy() {
        MeshData data = new MeshData();
        data._vertexCount = this._vertexCount;
        data._primitiveCounts = new int[this._primitiveCounts.length];
        System.arraycopy(this._primitiveCounts, 0, data._primitiveCounts, 0, this._primitiveCounts.length);
        if (this._vertexCoords != null) {
            data._vertexCoords = this._vertexCoords.makeCopy();
        }
        if (this._normalCoords != null) {
            data._normalCoords = this._normalCoords.makeCopy();
        }
        if (this._colorCoords != null) {
            data._colorCoords = this._colorCoords.makeCopy();
        }
        if (this._fogCoords != null) {
            data._fogCoords = this._fogCoords.makeCopy();
        }
        if (this._tangentCoords != null) {
            data._tangentCoords = this._tangentCoords.makeCopy();
        }
        for (FloatBufferData tCoord : this._textureCoords) {
            if (tCoord != null) {
                data._textureCoords.add(tCoord.makeCopy());
                continue;
            }
            data._textureCoords.add(null);
        }
        if (this._indexBuffer != null) {
            data._indexBuffer = this._indexBuffer.makeCopy();
        }
        if (this._indexLengths != null) {
            data._indexLengths = new int[this._indexLengths.length];
            System.arraycopy(this._indexLengths, 0, data._indexLengths, 0, this._indexLengths.length);
        }
        data._indexModes = new IndexMode[this._indexModes.length];
        System.arraycopy(this._indexModes, 0, data._indexModes, 0, this._indexModes.length);
        return data;
    }

    public Class<? extends MeshData> getClassTag() {
        return this.getClass();
    }

    public void write(OutputCapsule capsule) throws IOException {
        capsule.write(this._vertexCount, "vertexCount", 0);
        capsule.write((Savable)this._vertexCoords, "vertexBuffer", null);
        capsule.write((Savable)this._normalCoords, "normalBuffer", null);
        capsule.write((Savable)this._colorCoords, "colorBuffer", null);
        capsule.write((Savable)this._fogCoords, "fogBuffer", null);
        capsule.write((Savable)this._tangentCoords, "tangentBuffer", null);
        capsule.writeSavableList(this._textureCoords, "textureCoords", new ArrayList(1));
        capsule.write((Savable)this._indexBuffer, "indexBuffer", null);
        capsule.write((Savable)this._interleaved, "interleaved", null);
        capsule.write(this._indexLengths, "indexLengths", null);
        capsule.write((Enum[])this._indexModes, "indexModes");
    }

    public void read(InputCapsule capsule) throws IOException {
        this._vertexCount = capsule.readInt("vertexCount", 0);
        this._vertexCoords = (FloatBufferData)capsule.readSavable("vertexBuffer", null);
        this._normalCoords = (FloatBufferData)capsule.readSavable("normalBuffer", null);
        this._colorCoords = (FloatBufferData)capsule.readSavable("colorBuffer", null);
        this._fogCoords = (FloatBufferData)capsule.readSavable("fogBuffer", null);
        this._tangentCoords = (FloatBufferData)capsule.readSavable("tangentBuffer", null);
        this._textureCoords = capsule.readSavableList("textureCoords", new ArrayList(1));
        this._indexBuffer = (IndexBufferData)capsule.readSavable("indexBuffer", null);
        this._interleaved = (FloatBufferData)capsule.readSavable("interleaved", null);
        this._indexLengths = capsule.readIntArray("indexLengths", null);
        this._indexModes = (IndexMode[])capsule.readEnumArray("indexModes", IndexMode.class, (Enum[])new IndexMode[]{IndexMode.Triangles});
        this.updatePrimitiveCounts();
    }

    public InstancingManager getInstancingManager() {
        return this._instancingManager;
    }

    public void setInstancingManager(InstancingManager info) {
        this._instancingManager = info;
    }
}

