/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph;

import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.event.DirtyType;
import com.ardor3d.scenegraph.visitor.Visitor;
import com.ardor3d.util.Ardor3dException;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.scenegraph.RenderDelegate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Node
extends Spatial {
    private static final Logger logger = Logger.getLogger(Node.class.getName());
    protected final List<Spatial> _children;

    public Node() {
        this._children = Collections.synchronizedList(new ArrayList(1));
    }

    public Node(String name) {
        this(name, Collections.synchronizedList(new ArrayList(1)));
    }

    public Node(String name, List<Spatial> children) {
        super(name);
        this._children = children;
    }

    public int attachChild(Spatial child) {
        if (child != null) {
            if (child == this || child instanceof Node && this.hasAncestor((Node)child)) {
                throw new IllegalArgumentException("Child is already part of this hierarchy.");
            }
            if (child.getParent() != this) {
                if (child.getParent() != null) {
                    child.getParent().detachChild(child);
                }
                child.setParent(this);
                this._children.add(child);
                child.markDirty(DirtyType.Attached);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Child (" + child.getName() + ") attached to this node (" + this.getName() + ")");
                }
            }
        }
        return this._children.size();
    }

    public int attachChildAt(Spatial child, int index) {
        if (child != null) {
            if (child == this || child instanceof Node && this.hasAncestor((Node)child)) {
                throw new IllegalArgumentException("Child is already part of this hierarchy.");
            }
            if (child.getParent() != this) {
                if (child.getParent() != null) {
                    child.getParent().detachChild(child);
                }
                child.setParent(this);
                this._children.add(index, child);
                child.markDirty(DirtyType.Attached);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Child (" + child.getName() + ") attached to this node (" + this.getName() + ")");
                }
            }
        }
        return this._children.size();
    }

    public int detachChild(Spatial child) {
        if (child == null) {
            return -1;
        }
        if (child.getParent() == this) {
            int index = this._children.indexOf(child);
            if (index != -1) {
                this.detachChildAt(index);
            }
            return index;
        }
        return -1;
    }

    public int detachChildNamed(String childName) {
        if (childName == null) {
            return -1;
        }
        for (int i = this.getNumberOfChildren() - 1; i >= 0; --i) {
            Spatial child = this._children.get(i);
            if (!childName.equals(child.getName())) continue;
            this.detachChildAt(i);
            return i;
        }
        return -1;
    }

    public Spatial detachChildAt(int index) {
        Spatial child = this._children.remove(index);
        if (child != null) {
            child.setParent(null);
            this.markDirty(child, DirtyType.Detached);
            if (child.getListener() != null) {
                child.setListener(null);
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.fine("Child removed.");
            }
        }
        return child;
    }

    public void detachAllChildren() {
        for (int i = this.getNumberOfChildren() - 1; i >= 0; --i) {
            this.detachChildAt(i);
        }
        logger.fine("All children removed.");
    }

    public int getChildIndex(Spatial sp) {
        return this._children.indexOf(sp);
    }

    public List<Spatial> getChildren() {
        return this._children;
    }

    public void swapChildren(int index1, int index2) {
        Spatial c2 = this._children.get(index2);
        Spatial c1 = this._children.remove(index1);
        this._children.add(index1, c2);
        this._children.remove(index2);
        this._children.add(index2, c1);
    }

    @Override
    protected void updateChildren(double time) {
        for (int i = this.getNumberOfChildren() - 1; i >= 0; --i) {
            Spatial pkChild = this.getChild(i);
            if (pkChild == null) continue;
            pkChild.updateGeometricState(time, false);
        }
    }

    public Spatial getChild(int i) {
        return this._children.get(i);
    }

    public Spatial getChild(String name) {
        if (name == null) {
            return null;
        }
        for (int i = this.getNumberOfChildren() - 1; i >= 0; --i) {
            Spatial out;
            Spatial child = this._children.get(i);
            if (name.equals(child.getName())) {
                return child;
            }
            if (!(child instanceof Node) || (out = ((Node)child).getChild(name)) == null) continue;
            return out;
        }
        return null;
    }

    public boolean hasChild(Spatial spat) {
        if (this._children.contains(spat)) {
            return true;
        }
        for (int i = this.getNumberOfChildren() - 1; i >= 0; --i) {
            Spatial child = this._children.get(i);
            if (!(child instanceof Node) || !((Node)child).hasChild(spat)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfChildren() {
        return this._children.size();
    }

    @Override
    protected void propagateDirtyDown(EnumSet<DirtyType> dirtyTypes) {
        super.propagateDirtyDown(dirtyTypes);
        for (int i = this.getNumberOfChildren() - 1; i >= 0; --i) {
            Spatial child = this._children.get(i);
            child.propagateDirtyDown(dirtyTypes);
        }
    }

    @Override
    public void updateWorldTransform(boolean recurse) {
        super.updateWorldTransform(recurse);
        if (recurse) {
            for (int i = this.getNumberOfChildren() - 1; i >= 0; --i) {
                this._children.get(i).updateWorldTransform(true);
            }
        }
    }

    @Override
    protected void updateWorldRenderStates(boolean recurse, RenderState.StateStack stack) {
        super.updateWorldRenderStates(recurse, stack);
        if (recurse) {
            for (int i = this.getNumberOfChildren() - 1; i >= 0; --i) {
                this._children.get(i).updateWorldRenderStates(true, stack);
            }
        }
    }

    @Override
    public void draw(Renderer r) {
        RenderDelegate delegate = this.getCurrentRenderDelegate();
        if (delegate == null) {
            for (int i = this.getNumberOfChildren() - 1; i >= 0; --i) {
                Spatial child = this._children.get(i);
                if (child == null) continue;
                child.onDraw(r);
            }
        } else {
            if (!r.isProcessingQueue() && r.checkAndAdd(this)) {
                return;
            }
            delegate.render(this, r);
        }
    }

    @Override
    public void updateWorldBound(boolean recurse) {
        BoundingVolume worldBound = null;
        for (int i = this.getNumberOfChildren() - 1; i >= 0; --i) {
            Spatial child = this._children.get(i);
            if (child == null) continue;
            if (recurse) {
                child.updateWorldBound(true);
            }
            if (worldBound != null) {
                worldBound.mergeLocal(child.getWorldBound());
                if (Vector3.isValid((ReadOnlyVector3)worldBound.getCenter())) continue;
                throw new Ardor3dException("WorldBound center is invalid after merge between " + this + " and " + child);
            }
            if (child.getWorldBound() == null) continue;
            worldBound = child.getWorldBound().clone(this._worldBound);
        }
        this._worldBound = worldBound;
        this.clearDirty(DirtyType.Bounding);
    }

    @Override
    public void acceptVisitor(Visitor visitor, boolean preexecute) {
        if (preexecute) {
            visitor.visit(this);
        }
        for (int i = this.getNumberOfChildren() - 1; i >= 0; --i) {
            Spatial child = this._children.get(i);
            if (child == null) continue;
            child.acceptVisitor(visitor, preexecute);
        }
        if (!preexecute) {
            visitor.visit(this);
        }
    }

    @Override
    public void sortLights() {
        for (int i = this.getNumberOfChildren() - 1; i >= 0; --i) {
            Spatial pkChild = this.getChild(i);
            if (pkChild == null) continue;
            pkChild.sortLights();
        }
    }

    @Override
    public Node makeCopy(boolean shareGeometricData) {
        Node node = (Node)super.makeCopy(shareGeometricData);
        for (Spatial child : this.getChildren()) {
            Spatial copy = child.makeCopy(shareGeometricData);
            node.attachChild(copy);
        }
        return node;
    }

    @Override
    public Node makeInstanced() {
        Node node = (Node)super.makeInstanced();
        for (Spatial child : this.getChildren()) {
            Spatial copy = child.makeInstanced();
            node.attachChild(copy);
        }
        return node;
    }

    public Class<? extends Node> getClassTag() {
        return this.getClass();
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.writeSavableList(new ArrayList<Spatial>(this._children), "children", null);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        List cList = capsule.readSavableList("children", null);
        this._children.clear();
        if (cList != null) {
            this._children.addAll(cList);
        }
        for (int i = this.getNumberOfChildren() - 1; i >= 0; --i) {
            Spatial child = this._children.get(i);
            child._parent = this;
        }
    }
}

