/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph;

import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector2;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.scenegraph.FloatBufferDataUtil;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.FloatBuffer;

public class Point
extends Mesh {
    private PointType _pointType;
    private float _pointSize = 1.0f;
    private boolean _antialiased = false;
    private final FloatBuffer _attenuationCoefficients = BufferUtils.createFloatBuffer(0.0f, 0.0f, 4.0E-6f, 0.0f);
    private float _minPointSize = 1.0f;
    private float _maxPointSize = 64.0f;
    private boolean _useDistanceAttenuation = false;

    public Point() {
        this("point", null, null, null, (FloatBufferData)null);
    }

    public Point(PointType type) {
        this();
        this._pointType = type;
    }

    public Point(String name, ReadOnlyVector3[] vertex, ReadOnlyVector3[] normal, ReadOnlyColorRGBA[] color, ReadOnlyVector2[] texture) {
        super(name);
        this.setupData(BufferUtils.createFloatBuffer(vertex), BufferUtils.createFloatBuffer(normal), BufferUtils.createFloatBuffer(color), FloatBufferDataUtil.makeNew(texture));
        this._meshData.setIndexMode(IndexMode.Points);
    }

    public Point(String name, FloatBuffer vertex, FloatBuffer normal, FloatBuffer color, FloatBufferData coords) {
        super(name);
        this.setupData(vertex, normal, color, coords);
        this._meshData.setIndexMode(IndexMode.Points);
    }

    private void setupData(FloatBuffer vertices, FloatBuffer normals, FloatBuffer colors, FloatBufferData coords) {
        this._meshData.setVertexBuffer(vertices);
        this._meshData.setNormalBuffer(normals);
        this._meshData.setColorBuffer(colors);
        this._meshData.setTextureCoords(coords, 0);
    }

    public boolean isPointSprite() {
        return this._pointType == PointType.PointSprite;
    }

    public void enableDistanceAttenuation(boolean bool) {
        this._useDistanceAttenuation = bool;
    }

    public void setDistanceAttenuationCoefficients(float a, float b, float c) {
        this._attenuationCoefficients.put(0, a);
        this._attenuationCoefficients.put(1, b);
        this._attenuationCoefficients.put(2, c);
    }

    public boolean isAntialiased() {
        return this._antialiased;
    }

    public void setAntialiased(boolean antialiased) {
        this._antialiased = antialiased;
    }

    public PointType getPointType() {
        return this._pointType;
    }

    public void setPointType(PointType pointType) {
        this._pointType = pointType;
    }

    public float getPointSize() {
        return this._pointSize;
    }

    public void setPointSize(float size) {
        this._pointSize = size;
    }

    public void setMaxPointSize(float maxSize) {
        this._maxPointSize = maxSize;
    }

    public float getMaxPointSize() {
        return this._maxPointSize;
    }

    public void setMinPointSize(float minSize) {
        this._minPointSize = minSize;
    }

    public float getMinPointSize() {
        return this._minPointSize;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public Point makeCopy(boolean shareGeometricData) {
        Point pointCopy = (Point)super.makeCopy(shareGeometricData);
        pointCopy.setAntialiased(this._antialiased);
        pointCopy.setDistanceAttenuationCoefficients(this._attenuationCoefficients.get(0), this._attenuationCoefficients.get(1), this._attenuationCoefficients.get(2));
        pointCopy.setMaxPointSize(this._maxPointSize);
        pointCopy.setMinPointSize(this._minPointSize);
        pointCopy.setPointSize(this._pointSize);
        pointCopy.setPointType(this._pointType);
        return pointCopy;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this._pointSize, "pointSize", 1.0f);
        capsule.write(this._antialiased, "antialiased", false);
        capsule.write((Enum)this._pointType, "pointType", (Enum)PointType.Point);
        capsule.write(this._useDistanceAttenuation, "useDistanceAttenuation", false);
        capsule.write(this._attenuationCoefficients, "attenuationCoefficients", null);
        capsule.write(this._minPointSize, "minPointSize", 1.0f);
        capsule.write(this._maxPointSize, "maxPointSize", 64.0f);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._pointSize = capsule.readFloat("pointSize", 1.0f);
        this._antialiased = capsule.readBoolean("antialiased", false);
        this._pointType = (PointType)capsule.readEnum("pointType", PointType.class, (Enum)PointType.Point);
        this._useDistanceAttenuation = capsule.readBoolean("useDistanceAttenuation", false);
        FloatBuffer coef = capsule.readFloatBuffer("attenuationCoefficients", null);
        if (coef == null) {
            this._attenuationCoefficients.clear();
            this._attenuationCoefficients.put(new float[]{0.0f, 0.0f, 4.0E-6f, 0.0f});
        } else {
            this._attenuationCoefficients.clear();
            this._attenuationCoefficients.put(coef);
        }
        this._minPointSize = capsule.readFloat("minPointSize", 1.0f);
        this._maxPointSize = capsule.readFloat("maxPointSize", 64.0f);
    }

    @Override
    public void render(Renderer renderer) {
        renderer.setupPointParameters(this._pointSize, this.isAntialiased(), this.isPointSprite(), this._useDistanceAttenuation, this._attenuationCoefficients, this._minPointSize, this._maxPointSize);
        super.render(renderer);
    }

    public static enum PointType {
        Point,
        PointSprite;

    }
}

