/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.scenegraph;

import com.ardor3d.scenegraph.IndexBufferData;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class ShortBufferData
extends IndexBufferData<ShortBuffer>
implements Savable {
    public ShortBufferData() {
    }

    public ShortBufferData(int size) {
        this(BufferUtils.createShortBuffer(size));
    }

    public ShortBufferData(ShortBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer can not be null!");
        }
        this._buffer = buffer;
    }

    public Class<? extends ShortBufferData> getClassTag() {
        return this.getClass();
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._buffer = capsule.readShortBuffer("buffer", null);
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((ShortBuffer)this._buffer, "buffer", null);
    }

    @Override
    public int get() {
        return ((ShortBuffer)this._buffer).get() & 0xFFFF;
    }

    @Override
    public int get(int index) {
        return ((ShortBuffer)this._buffer).get(index) & 0xFFFF;
    }

    public ShortBufferData put(int value) {
        if (value < 0 || value >= 65536) {
            throw new IllegalArgumentException("Invalid value passed to short buffer: " + value);
        }
        ((ShortBuffer)this._buffer).put((short)value);
        return this;
    }

    public ShortBufferData put(int index, int value) {
        if (value < 0 || value >= 65536) {
            throw new IllegalArgumentException("Invalid value passed to short buffer: " + value);
        }
        ((ShortBuffer)this._buffer).put(index, (short)value);
        return this;
    }

    @Override
    public void put(IndexBufferData<?> buf) {
        if (buf instanceof ShortBufferData) {
            ((ShortBuffer)this._buffer).put((ShortBuffer)buf.getBuffer());
        } else {
            while (((Buffer)buf.getBuffer()).hasRemaining()) {
                this.put(buf.get());
            }
        }
    }

    @Override
    public void put(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            this.put(array[i]);
        }
    }

    @Override
    public void put(int[] array, int offset, int length) {
        int max = offset + length;
        for (int i = offset; i < max; ++i) {
            this.put(array[i]);
        }
    }

    @Override
    public int getByteCount() {
        return 2;
    }

    @Override
    public ShortBuffer getBuffer() {
        return (ShortBuffer)this._buffer;
    }

    @Override
    public IntBuffer asIntBuffer() {
        ShortBuffer source = this.getBuffer().duplicate();
        source.rewind();
        IntBuffer buff = BufferUtils.createIntBufferOnHeap(source.limit());
        int max = source.limit();
        for (int i = 0; i < max; ++i) {
            buff.put(source.get() & 0xFFFF);
        }
        buff.flip();
        return buff;
    }

    @Override
    public ShortBufferData makeCopy() {
        ShortBufferData copy = new ShortBufferData();
        copy._buffer = BufferUtils.clone((ShortBuffer)this._buffer);
        copy._vboAccessMode = this._vboAccessMode;
        return copy;
    }
}

